package charactermanaj.graphics.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface ImageResource extends Comparable<ImageResource> {

	InputStream openStream() throws IOException;
	
	long lastModified();
	
	int hashCode();
	
	boolean equals(Object obj);
	
	int compareTo(ImageResource o);
	
	String getFullName();

	URL getURL();
}
