/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import charactermanaj.util.ApplicationLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.apache.tools.zip.AbstractUnicodeExtraField;
import org.apache.tools.zip.UnicodeCommentExtraField;
import org.apache.tools.zip.UnicodePathExtraField;
import org.apache.tools.zip.ZipEncoding;
import org.apache.tools.zip.ZipEncodingHelper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipOutputStream;
import org.apache.tools.zip.ZipShort;

public class ZipFile {
    private static final Logger logger = ApplicationLogger.getLogger();
    private static final int HASH_SIZE = 509;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private static final int NIBLET_MASK = 15;
    private static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private final Map entries = new HashMap(509);
    private final Map nameMap = new HashMap(509);
    private String encoding = null;
    private final ZipEncoding zipEncoding;
    private RandomAccessFile archive;
    private final boolean useUnicodeExtraFields;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;

    public ZipFile(File file) throws IOException {
        this(file, null);
    }

    public ZipFile(String string) throws IOException {
        this(new File(string), null);
    }

    public ZipFile(String string, String string2) throws IOException {
        this(new File(string), string2, true);
    }

    public ZipFile(File file, String string) throws IOException {
        this(file, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(File file, String string, boolean bl) throws IOException {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUnicodeExtraFields = bl;
        this.archive = new RandomAccessFile(file, "r");
        boolean bl2 = false;
        try {
            Map map = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(map);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration getEntries() {
        return Collections.enumeration(this.entries.keySet());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.nameMap.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
        OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(zipEntry);
        if (offsetEntry == null) {
            return null;
        }
        long l = offsetEntry.dataOffset;
        BoundedInputStream boundedInputStream = new BoundedInputStream(l, zipEntry.getCompressedSize());
        switch (zipEntry.getMethod()) {
            case 0: {
                return boundedInputStream;
            }
            case 8: {
                boundedInputStream.addDummy();
                return new InflaterInputStream(boundedInputStream, new Inflater(true));
            }
        }
        throw new ZipException("Found unsupported compression method " + zipEntry.getMethod());
    }

    private Map populateFromCentralDirectory() throws IOException {
        HashMap<ZipEntry, NameAndComment> hashMap = new HashMap<ZipEntry, NameAndComment>();
        this.positionAtCentralDirectory();
        byte[] byArray = new byte[42];
        byte[] byArray2 = new byte[4];
        this.archive.readFully(byArray2);
        long l = ZipLong.getValue(byArray2);
        long l2 = ZipLong.getValue(ZipOutputStream.CFH_SIG);
        if (l != l2 && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (l == l2) {
            this.archive.readFully(byArray);
            int n = 0;
            ZipEntry zipEntry = new ZipEntry();
            int n2 = ZipShort.getValue(byArray, n);
            n += 2;
            zipEntry.setPlatform(n2 >> 8 & 0xF);
            int n3 = ZipShort.getValue(byArray, n += 2);
            boolean bl = (n3 & 0x800) != 0;
            ZipEncoding zipEncoding = bl ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
            zipEntry.setMethod(ZipShort.getValue(byArray, n += 2));
            long l3 = ZipFile.dosToJavaTime(ZipLong.getValue(byArray, n += 2));
            zipEntry.setTime(l3);
            zipEntry.setCrc(ZipLong.getValue(byArray, n += 4));
            zipEntry.setCompressedSize(ZipLong.getValue(byArray, n += 4));
            zipEntry.setSize(ZipLong.getValue(byArray, n += 4));
            int n4 = ZipShort.getValue(byArray, n += 4);
            int n5 = ZipShort.getValue(byArray, n += 2);
            int n6 = ZipShort.getValue(byArray, n += 2);
            n += 2;
            zipEntry.setInternalAttributes(ZipShort.getValue(byArray, n += 2));
            zipEntry.setExternalAttributes(ZipLong.getValue(byArray, n += 2));
            byte[] byArray3 = new byte[n4];
            this.archive.readFully(byArray3);
            zipEntry.setName(zipEncoding.decode(byArray3));
            OffsetEntry offsetEntry = new OffsetEntry();
            offsetEntry.headerOffset = ZipLong.getValue(byArray, n += 4);
            this.entries.put(zipEntry, offsetEntry);
            this.nameMap.put(zipEntry.getName(), zipEntry);
            byte[] byArray4 = new byte[n5];
            this.archive.readFully(byArray4);
            zipEntry.setCentralDirectoryExtra(byArray4);
            byte[] byArray5 = new byte[n6];
            this.archive.readFully(byArray5);
            zipEntry.setComment(zipEncoding.decode(byArray5));
            this.archive.readFully(byArray2);
            l = ZipLong.getValue(byArray2);
            if (bl || !this.useUnicodeExtraFields) continue;
            hashMap.put(zipEntry, new NameAndComment(byArray3, byArray5));
        }
        return hashMap;
    }

    private void positionAtCentralDirectory() throws IOException {
        byte[] byArray;
        boolean bl = false;
        long l = this.archive.length() - 22L;
        long l2 = Math.max(0L, this.archive.length() - 65557L);
        if (l >= 0L) {
            this.archive.seek(l);
            byArray = ZipOutputStream.EOCD_SIG;
            int n = this.archive.read();
            while (l >= l2 && n != -1) {
                if (n == byArray[0] && (n = this.archive.read()) == byArray[1] && (n = this.archive.read()) == byArray[2] && (n = this.archive.read()) == byArray[3]) {
                    bl = true;
                    break;
                }
                this.archive.seek(--l);
                n = this.archive.read();
            }
        }
        if (!bl) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(l + 16L);
        byArray = new byte[4];
        this.archive.readFully(byArray);
        this.archive.seek(ZipLong.getValue(byArray));
    }

    private void resolveLocalFileHeaderData(Map map) throws IOException {
        Enumeration enumeration = this.getEntries();
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(zipEntry);
            long l = offsetEntry.headerOffset;
            this.archive.seek(l + 26L);
            byte[] byArray = new byte[2];
            this.archive.readFully(byArray);
            int n2 = ZipShort.getValue(byArray);
            this.archive.readFully(byArray);
            int n3 = ZipShort.getValue(byArray);
            for (int i = n2; i > 0; i -= n) {
                n = this.archive.skipBytes(i);
                if (n > 0) continue;
                throw new RuntimeException("failed to skip file name in local file header");
            }
            byte[] byArray2 = new byte[n3];
            this.archive.readFully(byArray2);
            zipEntry.setExtra(byArray2);
            offsetEntry.dataOffset = l + 26L + 2L + 2L + (long)n2 + (long)n3;
            if (!map.containsKey(zipEntry)) continue;
            this.setNameAndCommentFromExtraFields(zipEntry, (NameAndComment)map.get(zipEntry));
        }
    }

    protected static Date fromDosTime(ZipLong zipLong) {
        long l = zipLong.getValue();
        return new Date(ZipFile.dosToJavaTime(l));
    }

    private static long dosToJavaTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)(l >> 25 & 0x7FL) + 1980);
        calendar.set(2, (int)(l >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l >> 16) & 0x1F);
        calendar.set(11, (int)(l >> 11) & 0x1F);
        calendar.set(12, (int)(l >> 5) & 0x3F);
        calendar.set(13, (int)(l << 1) & 0x3E);
        return calendar.getTime().getTime();
    }

    protected String getString(byte[] byArray) throws ZipException {
        try {
            return ZipEncodingHelper.getZipEncoding(this.encoding).decode(byArray);
        }
        catch (IOException iOException) {
            throw new ZipException("Failed to decode name: " + iOException.getMessage());
        }
    }

    private boolean startsWithLocalFileHeader() throws IOException {
        this.archive.seek(0L);
        byte[] byArray = new byte[4];
        this.archive.readFully(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == ZipOutputStream.LFH_SIG[i]) continue;
            return false;
        }
        return true;
    }

    private void setNameAndCommentFromExtraFields(ZipEntry zipEntry, NameAndComment nameAndComment) {
        UnicodeCommentExtraField unicodeCommentExtraField;
        String string;
        UnicodePathExtraField unicodePathExtraField = (UnicodePathExtraField)zipEntry.getExtraField(UnicodePathExtraField.UPATH_ID);
        String string2 = zipEntry.getName();
        String string3 = this.getUnicodeStringIfOriginalMatches(unicodePathExtraField, nameAndComment.name);
        if (string3 != null && !string2.equals(string3)) {
            zipEntry.setName(string3);
            this.nameMap.remove(string2);
            this.nameMap.put(string3, zipEntry);
        }
        if (nameAndComment.comment != null && nameAndComment.comment.length > 0 && (string = this.getUnicodeStringIfOriginalMatches(unicodeCommentExtraField = (UnicodeCommentExtraField)zipEntry.getExtraField(UnicodeCommentExtraField.UCOM_ID), nameAndComment.comment)) != null) {
            zipEntry.setComment(string);
        }
    }

    private String getUnicodeStringIfOriginalMatches(AbstractUnicodeExtraField abstractUnicodeExtraField, byte[] byArray) {
        if (abstractUnicodeExtraField != null) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            long l = cRC32.getValue();
            if (l == abstractUnicodeExtraField.getNameCRC32()) {
                try {
                    return ZipEncodingHelper.UTF8_ZIP_ENCODING.decode(abstractUnicodeExtraField.getUnicodeName());
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "ZipFile: UTF-8 unsupported. should be impossible the Unicode*ExtraField must contain some bad bytes.", iOException);
                    return null;
                }
            }
        }
        return null;
    }

    private static final class NameAndComment {
        private final byte[] name;
        private final byte[] comment;

        private NameAndComment(byte[] byArray, byte[] byArray2) {
            this.name = byArray;
            this.comment = byArray2;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long l, long l2) {
            this.remaining = l2;
            this.loc = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc++);
                return ZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            int n3 = -1;
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc);
                n3 = ZipFile.this.archive.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.loc += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }

    private static final class OffsetEntry {
        private long headerOffset = -1L;
        private long dataOffset = -1L;

        private OffsetEntry() {
        }
    }
}

