/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.zip.ZipEncoding;
import org.apache.tools.zip.ZipEncodingHelper;

class Simple8BitZipEncoding
implements ZipEncoding {
    private final char[] highChars;
    private final List reverseMapping;

    public Simple8BitZipEncoding(char[] cArray) {
        this.highChars = cArray;
        this.reverseMapping = new ArrayList(this.highChars.length);
        byte by = 127;
        for (int i = 0; i < this.highChars.length; ++i) {
            by = (byte)(by + 1);
            this.reverseMapping.add(new Simple8BitChar(by, this.highChars[i]));
        }
        Collections.sort(this.reverseMapping);
    }

    public char decodeByte(byte by) {
        if (by >= 0) {
            return (char)by;
        }
        return this.highChars[128 + by];
    }

    public boolean canEncodeChar(char c) {
        if (c >= '\u0000' && c < '\u0080') {
            return true;
        }
        Simple8BitChar simple8BitChar = this.encodeHighChar(c);
        return simple8BitChar != null;
    }

    public boolean pushEncodedChar(ByteBuffer byteBuffer, char c) {
        if (c >= '\u0000' && c < '\u0080') {
            byteBuffer.put((byte)c);
            return true;
        }
        Simple8BitChar simple8BitChar = this.encodeHighChar(c);
        if (simple8BitChar == null) {
            return false;
        }
        byteBuffer.put(simple8BitChar.code);
        return true;
    }

    private Simple8BitChar encodeHighChar(char c) {
        int n = 0;
        int n2 = this.reverseMapping.size();
        while (n2 > n) {
            int n3 = n + (n2 - n) / 2;
            Simple8BitChar simple8BitChar = (Simple8BitChar)this.reverseMapping.get(n3);
            if (simple8BitChar.unicode == c) {
                return simple8BitChar;
            }
            if (simple8BitChar.unicode < c) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        if (n >= this.reverseMapping.size()) {
            return null;
        }
        Simple8BitChar simple8BitChar = (Simple8BitChar)this.reverseMapping.get(n);
        if (simple8BitChar.unicode != c) {
            return null;
        }
        return simple8BitChar;
    }

    public boolean canEncode(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.canEncodeChar(c)) continue;
            return false;
        }
        return true;
    }

    public ByteBuffer encode(String string) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() + 6 + (string.length() + 1) / 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (byteBuffer.remaining() < 6) {
                byteBuffer = ZipEncodingHelper.growBuffer(byteBuffer, byteBuffer.position() + 6);
            }
            if (this.pushEncodedChar(byteBuffer, c)) continue;
            ZipEncodingHelper.appendSurrogate(byteBuffer, c);
        }
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        return byteBuffer;
    }

    public String decode(byte[] byArray) throws IOException {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = this.decodeByte(byArray[i]);
        }
        return new String(cArray);
    }

    private static final class Simple8BitChar
    implements Comparable {
        public final char unicode;
        public final byte code;

        Simple8BitChar(byte by, char c) {
            this.code = by;
            this.unicode = c;
        }

        public int compareTo(Object object) {
            Simple8BitChar simple8BitChar = (Simple8BitChar)object;
            return this.unicode - simple8BitChar.unicode;
        }

        public String toString() {
            return "0x" + Integer.toHexString(0xFFFF & this.unicode) + "->0x" + Integer.toHexString(0xFF & this.code);
        }
    }
}

