/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tools.zip.ZipEncoding;

class FallbackZipEncoding
implements ZipEncoding {
    private final String charset;

    public FallbackZipEncoding() {
        this.charset = null;
    }

    public FallbackZipEncoding(String string) {
        this.charset = string;
    }

    public boolean canEncode(String string) {
        return true;
    }

    public ByteBuffer encode(String string) throws IOException {
        if (this.charset == null) {
            return ByteBuffer.wrap(string.getBytes());
        }
        return ByteBuffer.wrap(string.getBytes(this.charset));
    }

    public String decode(byte[] byArray) throws IOException {
        if (this.charset == null) {
            return new String(byArray);
        }
        return new String(byArray, this.charset);
    }
}

