/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;

public class LocalizedResourceTextLoader
extends ResourceLoader {
    private static final LocalizedResourceTextLoader inst = new LocalizedResourceTextLoader();

    private LocalizedResourceTextLoader() {
    }

    public static LocalizedResourceTextLoader getInstance() {
        return inst;
    }

    public String getText(String string, Charset charset) {
        return this.getText(string, charset, Locale.getDefault());
    }

    public String getText(String string, Charset charset, Locale locale) {
        String string2;
        String string3;
        if (string == null || string.length() == 0 || charset == null || locale == null) {
            throw new IllegalArgumentException();
        }
        String string4 = locale.getLanguage();
        String string5 = locale.getCountry();
        String string6 = locale.getVariant();
        int n = string.lastIndexOf(".");
        int n2 = string.lastIndexOf("/");
        if (n2 > n) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        }
        String[] stringArray = new String[]{string3 + "_" + string4 + "_" + string5 + "_" + string6 + string2, string3 + "_" + string4 + "_" + string5 + string2, string3 + "_" + string4 + string2, string3 + string2};
        ResourceLoader.ResourceNames resourceNames = new ResourceLoader.ResourceNames(stringArray);
        String string7 = this.loadText(resourceNames, charset);
        if (string7 == null) {
            throw new RuntimeException("resource not found: " + resourceNames);
        }
        return string7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadText(ResourceLoader.ResourceNames resourceNames, Charset charset) {
        if (resourceNames == null || charset == null) {
            throw new IllegalArgumentException();
        }
        for (String string : resourceNames) {
            URL uRL = this.getResource(string);
            if (uRL == null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    int n;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
                    while ((n = bufferedReader.read()) != -1) {
                        stringBuilder.append((char)n);
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("resource loading error: " + iOException, iOException);
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

