/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class ErrorMessageHelper {
    private static final Logger logger = ApplicationLogger.getLogger();

    private ErrorMessageHelper() {
    }

    public static void showErrorDialog(Component component, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        logger.log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        JTextArea jTextArea = new JTextArea();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        jTextArea.setText(stringWriter.toString());
        jTextArea.setSelectionStart(0);
        jTextArea.setSelectionEnd(0);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(400, 150));
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JOptionPane.showMessageDialog(component, jScrollPane, "ERROR", 0);
    }
}

