/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class SamplePicturePanel
extends JPanel {
    private static final long serialVersionUID = 4026181978500938152L;
    protected BufferedImage samplePicture;
    protected boolean visiblePicture = true;
    protected Color sampleImageBgColor = AppConfig.getInstance().getSampleImageBgColor();
    protected String alternateText = "";
    protected boolean enableRealsize;

    public SamplePicturePanel() {
        this.setMinimumSize(new Dimension(64, 64));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    SamplePicturePanel.this.onDblClick();
                }
            }
        });
    }

    public SamplePicturePanel(BufferedImage bufferedImage) {
        this.setMinimumSize(new Dimension(64, 64));
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        this.samplePicture = bufferedImage;
        this.alternateText = "";
        this.enableRealsize = false;
        this.adjustPreferrerdSize(false);
    }

    public SamplePicturePanel(BufferedImage bufferedImage, String string) {
        this.setMinimumSize(new Dimension(64, 64));
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        if (string == null) {
            string = "";
        }
        this.samplePicture = bufferedImage;
        this.alternateText = string;
        this.enableRealsize = false;
        this.adjustPreferrerdSize(false);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        if (this.samplePicture != null && this.isVisiblePicture()) {
            Rectangle rectangle = this.getBounds();
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = rectangle.width - insets.left - insets.right;
            int n4 = rectangle.height - insets.top - insets.bottom;
            int n5 = this.samplePicture.getWidth();
            int n6 = this.samplePicture.getHeight();
            double d = (double)n4 / (double)n6;
            double d2 = (double)n3 / (double)n5;
            double d3 = Math.min(d, d2);
            int n7 = (int)((double)n5 * d3);
            int n8 = (int)((double)n6 * d3);
            int n9 = (n3 - n7) / 2;
            int n10 = (n4 - n8) / 2;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(this.samplePicture, n + n9, n2 + n10, n + n9 + n7, n2 + n10 + n8, 0, 0, n5, n6, this.sampleImageBgColor, null);
        } else if (this.alternateText.length() > 0) {
            Rectangle rectangle = this.getBounds();
            Insets insets = this.getInsets();
            int n = insets.left;
            int n11 = insets.top;
            int n12 = rectangle.width - insets.left - insets.right;
            int n13 = rectangle.height - insets.top - insets.bottom;
            Font font = graphics2D.getFont();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n14 = (int)font.getMaxCharBounds(fontRenderContext).getHeight();
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(n, n11, n12, n13);
            graphics2D.drawString(this.alternateText, n, n11 + n14);
            graphics2D.setClip(shape);
        }
    }

    public void adjustPreferrerdSize(boolean bl) {
        Dimension dimension;
        Dimension dimension2 = dimension = this.getMinimumSize();
        String string = null;
        if (this.samplePicture != null) {
            int n = bl ? 1 : 2;
            Insets insets = this.getInsets();
            dimension2 = new Dimension(this.samplePicture.getWidth() / n + insets.left + insets.right, this.samplePicture.getHeight() / n + insets.top + insets.bottom);
            Container container = this.getParent();
            if (container != null && container instanceof JViewport) {
                Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/samplepicturepanel");
                string = !bl ? properties.getProperty("dblclick.fullsize") : properties.getProperty("dblclick.fit");
            }
        }
        this.setToolTipText(string);
        dimension2.width = Math.max(dimension.width, dimension2.width);
        dimension2.height = Math.max(dimension.height, dimension2.height);
        Dimension dimension3 = this.getPreferredSize();
        if (dimension3 == null || !dimension3.equals(dimension2)) {
            this.setPreferredSize(dimension2);
            this.revalidate();
        }
    }

    public Dimension getPreferredSize() {
        Container container = this.getParent();
        if (!this.enableRealsize && container != null && container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Dimension dimension = jViewport.getExtentSize();
            Insets insets = jViewport.getInsets();
            Dimension dimension2 = new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            return dimension2;
        }
        return super.getPreferredSize();
    }

    protected void onDblClick() {
        Container container = this.getParent();
        if (container != null && container instanceof JViewport) {
            this.enableRealsize = !this.enableRealsize;
            this.adjustPreferrerdSize(this.enableRealsize);
        }
    }

    public boolean isVisiblePicture() {
        return this.visiblePicture;
    }

    public void setVisiblePicture(boolean bl) {
        if (this.visiblePicture != bl) {
            this.visiblePicture = bl;
            this.repaint();
        }
    }

    public void setSamplePicture(BufferedImage bufferedImage) {
        if (this.samplePicture != bufferedImage) {
            this.samplePicture = bufferedImage;
            this.enableRealsize = false;
            this.adjustPreferrerdSize(false);
            this.repaint();
        }
    }

    public BufferedImage getSamplePictrue() {
        return this.samplePicture;
    }

    public Color getSamplePictureBgColor() {
        return this.sampleImageBgColor;
    }

    public void setSamplePictureBgColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        if (!this.sampleImageBgColor.equals(color)) {
            this.sampleImageBgColor = color;
            this.repaint();
        }
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public void setAlternateText(String string) {
        if (string == null) {
            string = "";
        }
        if (!this.alternateText.equals(string)) {
            this.alternateText = string;
            this.repaint();
        }
    }
}

