/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.PartsDataLoader;
import charactermanaj.model.io.PartsDataLoaderFactory;
import charactermanaj.model.io.PartsSpecDecorateLoader;
import charactermanaj.model.io.RecentDataPersistent;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileEditDialog;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSelectorDialog
extends JDialog {
    private static final long serialVersionUID = -6883202891172975022L;
    private static final Logger logger = ApplicationLogger.getLogger();
    protected static final String STRINGS_RESOURCE = "strings/profileselectordialog";
    private ImageCachedLoader imageLoader = new ImageCachedLoader(10, 60000L);
    private boolean canWriteSamplePicture;
    private SamplePicturePanel sampleImgPanel;
    private JButton btnOK;
    private JButton btnProfileNew;
    private JButton btnProfileEdit;
    private JButton btnProfileRemove;
    private JButton btnProfileBrowse;
    private JButton btnProfileImport;
    private JButton btnProfileExport;
    private JList characterList;
    private DefaultListModel characterListModel;
    private JTextArea descriptionArea;
    private List<CharacterData> characterDatas;
    private CharacterData selectedCharacterData;

    private ProfileSelectorDialog(JFrame jFrame, List<CharacterData> list) {
        super((Frame)jFrame, true);
        Serializable serializable2;
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.characterDatas = list;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProfileSelectorDialog.this.onClosing();
            }
        });
        final Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(properties.getProperty("title"));
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 1);
        jPanel.setLayout(gridLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.characterListModel = new DefaultListModel();
        for (Serializable serializable2 : list) {
            this.characterListModel.addElement(serializable2);
        }
        this.characterList = new JList(this.characterListModel);
        this.characterList.setSelectionMode(0);
        this.characterList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                CharacterData characterData = (CharacterData)object;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(characterData.getName());
                if (MainFrame.isUsingCharacterData(characterData)) {
                    stringBuilder.append(properties.getProperty("profile.opend"));
                }
                if (!characterData.canWrite()) {
                    stringBuilder.append(properties.getProperty("profile.noteditable"));
                }
                if (characterData.isDefaultProfile()) {
                    stringBuilder.append(properties.getProperty("profile.default"));
                }
                return super.getListCellRendererComponent((JList<?>)jList, stringBuilder.toString(), n, bl, bl2);
            }
        });
        this.characterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfileSelectorDialog.this.updateUIState();
            }
        });
        this.characterList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    ProfileSelectorDialog.this.onOK();
                }
            }
        });
        jPanel2.add((Component)this.characterList, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        serializable2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout((LayoutManager)((Object)serializable2));
        this.btnProfileNew = new JButton(new AbstractAction(properties.getProperty("profile.new")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = (actionEvent.getModifiers() & 1) != 0;
                ProfileSelectorDialog.this.onProfileNew(bl);
            }
        });
        this.btnProfileEdit = new JButton(new AbstractAction(properties.getProperty("profile.edit")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onProfileEdit();
            }
        });
        this.btnProfileRemove = new JButton(new AbstractAction(properties.getProperty("profile.remove")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onProfileRemove();
            }
        });
        this.btnProfileBrowse = new JButton(new AbstractAction(properties.getProperty("profile.browse")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onProfileBrowse();
            }
        });
        this.btnProfileImport = new JButton(new AbstractAction(properties.getProperty("profile.import")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onProfileImport();
            }
        });
        this.btnProfileExport = new JButton(new AbstractAction(properties.getProperty("profile.export")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onProfileExport();
            }
        });
        this.btnProfileNew.setToolTipText(properties.getProperty("profile.new.tooltip"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel3.add((Component)this.btnProfileNew, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)this.btnProfileEdit, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel3.add((Component)this.btnProfileRemove, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)this.btnProfileBrowse, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)this.btnProfileImport, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        jPanel3.add((Component)this.btnProfileExport, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("profiles"))));
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "East");
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("description"))));
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setFont(this.getFont());
        jPanel6.add((Component)new JScrollPane(this.descriptionArea), "Center");
        this.sampleImgPanel = new SamplePicturePanel();
        this.sampleImgPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("sample-image"))));
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(new DropTargetAdapter(){

                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    ProfileSelectorDialog.this.onDrop(dropTargetDropEvent);
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new RuntimeException(tooManyListenersException.getMessage(), tooManyListenersException);
        }
        this.sampleImgPanel.setDropTarget(dropTarget);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        final JMenuItem jMenuItem = jPopupMenu.add(new AbstractAction(properties.getProperty("samplepicture.cut")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onSamplePictureCut();
            }
        });
        final JMenuItem jMenuItem2 = jPopupMenu.add(new AbstractAction(properties.getProperty("samplepicture.paste")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onSamplePicturePaste();
            }
        });
        this.sampleImgPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            private void evaluatePopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jMenuItem.setEnabled(ProfileSelectorDialog.this.sampleImgPanel.getSamplePictrue() != null && ProfileSelectorDialog.this.canWriteSamplePicture);
                    jMenuItem2.setEnabled(ProfileSelectorDialog.this.canWriteSamplePicture && ClipboardUtil.hasImage());
                    jPopupMenu.show(ProfileSelectorDialog.this.sampleImgPanel, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        jPanel5.add(jPanel6);
        jPanel5.add(this.sampleImgPanel);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        JPanel jPanel7 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel7, 2);
        jPanel7.setLayout(boxLayout);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("btn.select")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onOK();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(properties.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectorDialog.this.onCancel();
            }
        };
        this.btnOK = new JButton(abstractAction);
        JButton jButton = new JButton(abstractAction2);
        if (Main.isMacOSX()) {
            jPanel7.add(jButton);
            jPanel7.add(this.btnOK);
        } else {
            jPanel7.add(this.btnOK);
            jPanel7.add(jButton);
        }
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel7, "East");
        container.add((Component)jPanel8, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(this.btnOK);
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeProfileSelectorDialog");
        actionMap.put("closeProfileSelectorDialog", abstractAction2);
        this.pack();
        this.setSize(400, 500);
        this.setLocationRelativeTo(jFrame);
        this.characterList.requestFocus();
        this.updateUIState();
    }

    protected void updateUIState() {
        Object object;
        Object object2;
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        boolean bl = characterData != null;
        boolean bl2 = characterData != null && characterData.canWrite() && !MainFrame.isUsingCharacterData(characterData);
        this.btnOK.setEnabled(bl);
        this.btnProfileNew.setEnabled(true);
        this.btnProfileEdit.setEnabled(bl);
        this.btnProfileRemove.setEnabled(bl && bl2);
        this.btnProfileImport.setEnabled(true);
        this.btnProfileExport.setEnabled(bl);
        this.btnProfileBrowse.setEnabled(bl);
        if (bl2) {
            this.btnProfileEdit.setText(properties.getProperty("profile.edit"));
        } else {
            this.btnProfileEdit.setText(properties.getProperty("profile.edit.readonly"));
        }
        boolean bl3 = false;
        BufferedImage bufferedImage = null;
        if (characterData != null && characterData.isValid()) {
            Dimension dimension;
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            URL uRL = characterData.getDocBase();
            String string = characterData.getAuthor();
            String string2 = characterData.getDescription();
            if (uRL != null) {
                ((PrintWriter)object).println("configuration: " + uRL);
            }
            if (string != null && string.length() > 0) {
                ((PrintWriter)object).println("author: " + string);
            }
            if ((dimension = characterData.getImageSize()) != null) {
                ((PrintWriter)object).println("size: " + dimension.width + "x" + dimension.height);
            }
            if (string2 != null) {
                string2 = string2.replace("\r\n", "\n");
                string2 = string2.replace("\r", "\n");
                string2 = string2.replace("\n", System.getProperty("line.separator"));
                ((PrintWriter)object).println(string2);
            }
            this.descriptionArea.setText(((StringWriter)object2).toString());
            this.descriptionArea.setSelectionStart(0);
            this.descriptionArea.setSelectionEnd(0);
            try {
                CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
                bufferedImage = characterDataPersistent.loadSamplePicture(characterData, this.imageLoader);
                bl3 = characterDataPersistent.canSaveSamplePicture(characterData);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "sample picture loading failed. " + characterData, exception);
                bufferedImage = null;
            }
        }
        this.canWriteSamplePicture = bl3;
        object2 = properties.getProperty("dropHere");
        object = properties.getProperty("nopicture");
        this.sampleImgPanel.setSamplePicture(bufferedImage);
        this.sampleImgPanel.setAlternateText((String)(bl3 ? object2 : object));
    }

    protected void onSamplePictureCut() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        BufferedImage bufferedImage = this.sampleImgPanel.getSamplePictrue();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture || bufferedImage == null) {
            toolkit.beep();
            return;
        }
        try {
            Color color = AppConfig.getInstance().getSampleImageBgColor();
            ClipboardUtil.setImage(bufferedImage, color);
            CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
            characterDataPersistent.saveSamplePicture(characterData, null);
            this.sampleImgPanel.setSamplePicture(null);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onSamplePicturePaste() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture) {
            toolkit.beep();
            return;
        }
        try {
            BufferedImage bufferedImage = ClipboardUtil.getImage();
            if (bufferedImage != null) {
                CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
                characterDataPersistent.saveSamplePicture(characterData, bufferedImage);
                this.sampleImgPanel.setSamplePicture(bufferedImage);
            } else {
                toolkit.beep();
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDrop(DropTargetDropEvent dropTargetDropEvent) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture) {
            toolkit.beep();
            return;
        }
        try {
            void var5_10;
            File file = null;
            if (this.canWriteSamplePicture) {
                for (DataFlavor dataFlavor : dropTargetDropEvent.getCurrentDataFlavors()) {
                    if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) continue;
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (list.size() != 1) break;
                    file = (File)list.get(0);
                    break;
                }
            }
            Object var5_7 = null;
            if (file != null && file.isFile() && file.canRead()) {
                try {
                    BufferedImage bufferedImage = this.imageLoader.load(new FileImageResource(file));
                }
                catch (IOException iOException) {
                    Object var5_9 = null;
                }
            }
            if (var5_10 != null) {
                CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
                characterDataPersistent.saveSamplePicture(characterData, (BufferedImage)var5_10);
                this.sampleImgPanel.setSamplePicture((BufferedImage)var5_10);
            } else {
                toolkit.beep();
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onClosing() {
        this.dispose();
    }

    protected void onOK() {
        this.selectedCharacterData = (CharacterData)this.characterList.getSelectedValue();
        if (this.selectedCharacterData == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        this.dispose();
    }

    protected void onCancel() {
        this.selectedCharacterData = null;
        this.onClosing();
    }

    protected void onProfileNew(boolean bl) {
        Serializable serializable;
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        boolean bl2 = false;
        if (bl || characterData == null) {
            characterData = characterDataPersistent.createDefaultCharacterData();
        } else {
            serializable = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            int n = JOptionPane.showConfirmDialog(this, ((Properties)serializable).getProperty("useSameIdentifiers"), ((Properties)serializable).getProperty("confirmNewProfile"), 1, 3);
            if (n == 2) {
                return;
            }
            if (n != 0) {
                bl2 = true;
            }
        }
        serializable = characterData.duplicateBasicInfo(bl2);
        ((CharacterData)serializable).setDocBase(null);
        ((CharacterData)serializable).clearPartsSets(false);
        ProfileEditDialog profileEditDialog = new ProfileEditDialog(this, (CharacterData)serializable, false);
        profileEditDialog.setVisible(true);
        serializable = profileEditDialog.getResult();
        if (serializable == null) {
            return;
        }
        try {
            characterDataPersistent.createProfile((CharacterData)serializable);
            characterDataPersistent.saveFavorites((CharacterData)serializable);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
            return;
        }
        this.characterListModel.addElement(serializable);
    }

    protected void onProfileEdit() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        int n = this.characterList.getSelectedIndex();
        if (characterData == null || !characterData.isValid() || n < 0) {
            return;
        }
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        try {
            characterDataPersistent.loadFavorites(characterData);
        }
        catch (IOException iOException) {
            ErrorMessageHelper.showErrorDialog(this, iOException);
        }
        boolean bl = MainFrame.isUsingCharacterData(characterData);
        ProfileEditDialog profileEditDialog = new ProfileEditDialog(this, characterData, bl);
        profileEditDialog.setVisible(true);
        CharacterData characterData2 = profileEditDialog.getResult();
        if (characterData2 == null) {
            return;
        }
        boolean bl2 = characterData2.isSameStructure(characterData);
        try {
            characterDataPersistent.updateProfile(characterData2, !bl2);
            characterDataPersistent.saveFavorites(characterData2);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
            return;
        }
        this.characterListModel.set(n, characterData2);
        this.characterList.repaint();
    }

    protected void onProfileRemove() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        if (characterData == null || !characterData.isValid()) {
            return;
        }
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String string = properties.getProperty("profile.remove.confirm");
        MessageFormat messageFormat = new MessageFormat(string);
        String string2 = messageFormat.format(new Object[]{characterData.getName()});
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)new JLabel(string2), "Center");
        JCheckBox jCheckBox = new JCheckBox(properties.getProperty("profile.remove.force"));
        jPanel.add((Component)jCheckBox, "South");
        JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 0){
            private static final long serialVersionUID = 1L;

            public void selectInitialValue() {
                String string = UIManager.getString("OptionPane.noButtonText");
                for (JButton jButton : UIHelper.getInstance().getDescendantOfClass(JButton.class, this)) {
                    if (!jButton.getText().equals(string)) continue;
                    jButton.requestFocus();
                }
            }
        };
        JDialog jDialog = jOptionPane.createDialog(this, properties.getProperty("confirm.remove"));
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == null || ((Number)object).intValue() != 0) {
            return;
        }
        if (!characterData.canWrite() || characterData.getDocBase() == null) {
            JOptionPane.showMessageDialog(this, properties.getProperty("profile.remove.cannot"));
            return;
        }
        boolean bl = jCheckBox.isSelected();
        try {
            CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
            characterDataPersistent.remove(characterData, bl);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
            return;
        }
        this.characterListModel.removeElement(characterData);
        this.characterList.repaint();
        this.updateUIState();
    }

    protected void onProfileBrowse() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        if (characterData == null || !characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        try {
            URL uRL = characterData.getDocBase();
            if (!DesktopUtilities.browseBaseDir(uRL)) {
                JOptionPane.showMessageDialog(this, uRL);
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onProfileImport() {
        CharacterData characterData;
        CharacterData characterData2 = (CharacterData)this.characterList.getSelectedValue();
        if (characterData2 != null) {
            characterData = characterData2.duplicateBasicInfo(false);
            try {
                ProfileSelectorDialog.loadCharacterData(characterData);
            }
            catch (IOException iOException) {
                ErrorMessageHelper.showErrorDialog(this, iOException);
            }
        } else {
            characterData = null;
        }
        ImportWizardDialog importWizardDialog = new ImportWizardDialog(this, characterData, this.characterDatas);
        importWizardDialog.setVisible(true);
        if (importWizardDialog.getExitCode() == 2) {
            CharacterData characterData3 = importWizardDialog.getImportedCharacterData();
            this.characterListModel.addElement(characterData3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProfileExport() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        if (characterData == null || !characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        try {
            Object object;
            Object object2;
            CharacterData characterData2 = characterData.duplicateBasicInfo(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                object2 = PartsDataLoaderFactory.getInstance();
                object = ((PartsDataLoaderFactory)object2).createPartsLoader(characterData2.getDocBase());
                characterData2.loadPartsData((PartsDataLoader)object);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            object2 = this.sampleImgPanel.getSamplePictrue();
            object = new ExportWizardDialog(this, characterData2, (BufferedImage)object2);
            ((Dialog)object).setVisible(true);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainFrame openProfile(JFrame jFrame) throws IOException {
        MainFrame mainFrame;
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        List<CharacterData> list = characterDataPersistent.listProfiles(CharacterDataPersistent.DEFAULT_ERROR_HANDLER);
        ProfileSelectorDialog profileSelectorDialog = new ProfileSelectorDialog(jFrame, list);
        profileSelectorDialog.setVisible(true);
        CharacterData characterData = profileSelectorDialog.selectedCharacterData;
        if (characterData == null || !characterData.isValid()) {
            return null;
        }
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ProfileSelectorDialog.loadCharacterData(characterData);
            mainFrame = new MainFrame(characterData);
            ProfileSelectorDialog.saveRecent(characterData);
        }
        finally {
            jFrame.setCursor(Cursor.getDefaultCursor());
        }
        return mainFrame;
    }

    public static MainFrame openDefaultProfile() throws IOException {
        CharacterData characterData;
        AppConfig appConfig = AppConfig.getInstance();
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        try {
            characterData = ProfileSelectorDialog.loadRecent();
        }
        catch (IOException iOException) {
            ErrorMessageHelper.showErrorDialog(null, iOException);
            characterData = null;
        }
        if (characterData == null) {
            List<CharacterData> list = characterDataPersistent.listProfiles(CharacterDataPersistent.DEFAULT_ERROR_HANDLER);
            if (list.size() > 0) {
                String string = appConfig.getDefaultProfileId();
                if (string != null && string.trim().length() > 0) {
                    for (CharacterData characterData2 : list) {
                        if (!characterData2.getId().equals(string)) continue;
                        characterData = characterData2;
                        break;
                    }
                }
                if (characterData == null) {
                    characterData = list.get(0);
                }
            } else {
                try {
                    characterData = characterDataPersistent.createDefaultCharacterData();
                    characterDataPersistent.createProfile(characterData);
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "default profile creation failed.", iOException);
                    characterData = new CharacterData();
                }
            }
        }
        ProfileSelectorDialog.loadCharacterData(characterData);
        ProfileSelectorDialog.saveRecent(characterData);
        return new MainFrame(characterData);
    }

    protected static void loadCharacterData(CharacterData characterData) throws IOException {
        if (characterData != null && characterData.isValid()) {
            PartsDataLoaderFactory partsDataLoaderFactory = PartsDataLoaderFactory.getInstance();
            PartsDataLoader partsDataLoader = partsDataLoaderFactory.createPartsLoader(characterData.getDocBase());
            PartsSpecDecorateLoader partsSpecDecorateLoader = new PartsSpecDecorateLoader(partsDataLoader, characterData.getColorGroups());
            characterData.loadPartsData(partsSpecDecorateLoader);
            CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
            characterDataPersistent.loadFavorites(characterData);
        }
    }

    protected static void saveRecent(CharacterData characterData) throws IOException {
        RecentDataPersistent recentDataPersistent = RecentDataPersistent.getInstance();
        recentDataPersistent.saveRecent(characterData);
    }

    protected static CharacterData loadRecent() throws IOException {
        RecentDataPersistent recentDataPersistent = RecentDataPersistent.getInstance();
        return recentDataPersistent.loadRecent();
    }
}

