/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class PreviewImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color bgColor;
    private BufferedImage previewImg;

    public PreviewImagePanel() {
        AppConfig appConfig = AppConfig.getInstance();
        this.bgColor = appConfig.getDefaultImageBgColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.previewImg != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.bgColor);
                graphics.fillRect(0, 0, n, n2);
            }
            finally {
                graphics.setColor(color);
            }
            int n3 = this.previewImg.getWidth();
            int n4 = this.previewImg.getHeight();
            int n5 = 0;
            if (n3 < n) {
                n5 = (n - n3) / 2;
            }
            int n6 = 0;
            if (n4 < n2) {
                n6 = (n2 - n4) / 2;
            }
            graphics.drawImage(this.previewImg, n5, n6, n5 + n3, n6 + n4, 0, 0, n3, n4, null);
        }
    }

    public void setPreviewImage(BufferedImage bufferedImage) {
        this.previewImg = bufferedImage;
        if (bufferedImage != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            this.setPreferredSize(new Dimension(n, n2));
            this.revalidate();
        }
        this.repaint();
    }

    public BufferedImage getPreviewImage() {
        return this.previewImg;
    }

    public void setImageBgColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.bgColor != color) {
            this.bgColor = color;
            this.repaint();
        }
    }

    public Color getImageBgColor() {
        return this.bgColor;
    }
}

