/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.PresetsTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartssetsTableModel
extends AbstractTableModelWithComboBoxModel<PresetsTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = ApplicationLogger.getLogger();
    private static final String[] partssetsColumnNames;
    private static final int[] partssetsColumnWidths;
    private String defaultPartsSetId;

    public void setDefaultPartsSetId(String string) {
        this.defaultPartsSetId = string;
    }

    public String getDefaultPartsSetId() {
        return this.defaultPartsSetId;
    }

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        for (int i = 0; i < partssetsColumnWidths.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(partssetsColumnWidths[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return partssetsColumnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return partssetsColumnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PresetsTableRow presetsTableRow = (PresetsTableRow)this.elements.get(n);
        switch (n2) {
            case 0: {
                return presetsTableRow.getPartsSetId().equals(this.defaultPartsSetId);
            }
            case 1: {
                return presetsTableRow.isPresetParts();
            }
            case 2: {
                return presetsTableRow.getLocalizedName();
            }
            case 3: {
                return this.getUsedParts(presetsTableRow);
            }
        }
        return null;
    }

    private String getUsedParts(PresetsTableRow presetsTableRow) {
        StringBuilder stringBuilder = new StringBuilder();
        PartsSet partsSet = presetsTableRow.convert();
        ArrayList arrayList = new ArrayList(partsSet.keySet());
        Collections.sort(arrayList);
        for (PartsCategory partsCategory : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("[" + partsCategory.getLocalizedCategoryName() + "] ");
            List list = (List)partsSet.get(partsCategory);
            if (list.isEmpty()) {
                stringBuilder.append("empty");
                continue;
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(((PartsIdentifier)list.get(i)).getLocalizedPartsName());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PresetsTableRow presetsTableRow = (PresetsTableRow)this.elements.get(n);
        try {
            switch (n2) {
                case 0: {
                    if (!((Boolean)object).booleanValue()) break;
                    presetsTableRow.setPresetParts(true);
                    this.defaultPartsSetId = presetsTableRow.getPartsSetId();
                    this.fireTableDataChanged();
                    return;
                }
                case 1: {
                    if (((Boolean)object).booleanValue()) {
                        presetsTableRow.setPresetParts(true);
                        break;
                    }
                    presetsTableRow.setPresetParts(false);
                    if (!presetsTableRow.getPartsSetId().equals(this.defaultPartsSetId)) break;
                    this.defaultPartsSetId = null;
                    this.fireTableRowsUpdated(n, n);
                    return;
                }
                case 2: {
                    String string = (String)object;
                    if (string == null || string.trim().length() <= 0) break;
                    presetsTableRow.setLocalizedName(string.trim());
                    break;
                }
                case 3: {
                    return;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "value set failed. (" + n + ", " + n2 + "): " + object, exception);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.isEditable();
            }
            case 1: {
                return this.isEditable();
            }
            case 2: {
                return this.isEditable();
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/profileditdialog");
        partssetsColumnNames = new String[]{properties.getProperty("partssets.column.default"), properties.getProperty("partssets.column.preset"), properties.getProperty("partssets.column.partssetname"), properties.getProperty("partssets.column.usedpartsname")};
        partssetsColumnWidths = new int[]{Integer.parseInt(properties.getProperty("partssets.column.default.width")), Integer.parseInt(properties.getProperty("partssets.column.preset.width")), Integer.parseInt(properties.getProperty("partssets.column.partssetname.width")), Integer.parseInt(properties.getProperty("partssets.column.usedpartsname.width"))};
    }
}

