/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.MenuData;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuDataFactory
extends AbstractCollection<MenuDataFactory> {
    private String name;
    private ActionListener actionListener;
    private MenuDataFactory[] factories;

    public MenuDataFactory(String string) {
        this(string, null, null);
    }

    public MenuDataFactory(String string, MenuDataFactory[] menuDataFactoryArray) {
        this(string, null, menuDataFactoryArray);
    }

    public MenuDataFactory(String string, ActionListener actionListener) {
        this(string, actionListener, null);
    }

    public String getName() {
        return this.name;
    }

    public MenuDataFactory(String string, ActionListener actionListener, MenuDataFactory[] menuDataFactoryArray) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (menuDataFactoryArray == null) {
            menuDataFactoryArray = new MenuDataFactory[]{};
        }
        this.name = string;
        this.actionListener = actionListener;
        this.factories = menuDataFactoryArray;
    }

    public MenuData createMenuData(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        String string = properties.getProperty(this.name + ".text");
        String string2 = properties.getProperty(this.name + ".mnemonic");
        String string3 = properties.getProperty(this.name + ".mnemonicDisp");
        String string4 = properties.getProperty(this.name + ".ignoreMacOSX");
        MenuData menuData = new MenuData();
        menuData.setName(this.getName());
        menuData.setText(string);
        if (string2 != null && string2.length() > 0) {
            menuData.setMnemonic(Character.valueOf(string2.charAt(0)));
            menuData.setMnimonicDisp(string3);
        }
        menuData.setIgnoreMacOSX(string4 != null && Boolean.valueOf(string4) != false);
        menuData.setActionListener(this.actionListener);
        for (MenuDataFactory menuDataFactory : this.factories) {
            if (menuDataFactory != null) {
                menuData.add(menuDataFactory.createMenuData(properties));
                continue;
            }
            menuData.add(null);
        }
        return menuData;
    }

    @Override
    public int size() {
        return this.factories.length;
    }

    @Override
    public Iterator<MenuDataFactory> iterator() {
        return new Iterator<MenuDataFactory>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < MenuDataFactory.this.factories.length;
            }

            @Override
            public MenuDataFactory next() {
                if (this.idx >= MenuDataFactory.this.factories.length) {
                    throw new NoSuchElementException();
                }
                return MenuDataFactory.this.factories[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

