/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsSet;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ManageFavoriteDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/managefavoritesdialog";
    private CharacterData characterData;
    private DefaultListModel listModel;
    private JList list;
    private boolean dirty;

    public ManageFavoriteDialog(JFrame jFrame, CharacterData characterData) {
        super((Frame)jFrame, true);
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManageFavoriteDialog.this.onClose();
            }
        });
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(properties.getProperty("manageFavorites"));
        this.characterData = characterData;
        characterData.getPartsSets();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("remove")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ManageFavoriteDialog.this.onDelete();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(properties.getProperty("rename")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ManageFavoriteDialog.this.onRename();
            }
        };
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JButton(abstractAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JButton(abstractAction2), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        jPanel2.setLayout(new BorderLayout());
        AbstractAction abstractAction3 = new AbstractAction(properties.getProperty("close")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ManageFavoriteDialog.this.onClose();
            }
        };
        JButton jButton = new JButton(abstractAction3);
        jPanel2.add((Component)jButton, "East");
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(new Dimension(300, 150));
        container.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel, "East");
        container.add((Component)jPanel2, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteFav");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeManageFavoriteDialog");
        actionMap.put("deleteFav", abstractAction);
        actionMap.put("closeManageFavoriteDialog", abstractAction3);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.initListModel();
        this.list.repaint();
    }

    protected void initListModel() {
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>();
        for (PartsSet partsSet : this.characterData.getPartsSets().values()) {
            if (partsSet.isPresetParts()) continue;
            arrayList.add(partsSet);
        }
        Collections.sort(arrayList, new Comparator<PartsSet>(){

            @Override
            public int compare(PartsSet partsSet, PartsSet partsSet2) {
                int n = partsSet.getLocalizedName().compareTo(partsSet2.getLocalizedName());
                if (n == 0) {
                    n = partsSet.getPartsSetId().compareTo(partsSet2.getPartsSetId());
                }
                if (n == 0) {
                    n = partsSet.hashCode() - partsSet2.hashCode();
                }
                return n;
            }
        });
        this.list.setSelectedIndices(new int[0]);
        this.listModel.removeAllElements();
        for (PartsSet partsSet : arrayList) {
            this.listModel.addElement(partsSet);
        }
    }

    protected void onDelete() {
        Map<String, PartsSet> map = this.characterData.getPartsSets();
        for (Object object : this.list.getSelectedValues()) {
            PartsSet partsSet = (PartsSet)object;
            Iterator<Map.Entry<String, PartsSet>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PartsSet> entry = iterator.next();
                PartsSet partsSet2 = entry.getValue();
                if (partsSet2 != partsSet) continue;
                this.dirty = true;
                iterator.remove();
            }
        }
        this.initListModel();
        this.list.repaint();
    }

    protected void onRename() {
        Properties properties;
        String string;
        PartsSet partsSet = (PartsSet)this.list.getSelectedValue();
        if (partsSet != null && (string = JOptionPane.showInputDialog(this, (properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE)).getProperty("inputName"), partsSet.getLocalizedName())) != null) {
            partsSet.setLocalizedName(string);
            this.dirty = true;
            this.list.repaint();
        }
    }

    protected void onClose() {
        this.dispose();
    }

    public boolean isModified() {
        return this.dirty;
    }
}

