/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableRow;

class LayersTableRow {
    private String layerId;
    private String layerName;
    private CategoriesTableRow partsCategory;
    private ColorGroupsTableRow colorGroup = ColorGroupsTableRow.NA;
    private int order;
    private String dir;

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.layerId = string.trim();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.layerName = string.trim();
    }

    public CategoriesTableRow getPartsCategory() {
        return this.partsCategory;
    }

    public void setPartsCategory(CategoriesTableRow categoriesTableRow) {
        this.partsCategory = categoriesTableRow;
    }

    public ColorGroupsTableRow getColorGroup() {
        return this.colorGroup;
    }

    public void setColorGroup(ColorGroupsTableRow colorGroupsTableRow) {
        if (colorGroupsTableRow == null) {
            throw new IllegalArgumentException();
        }
        this.colorGroup = colorGroupsTableRow;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if ((string = string.trim()).indexOf("/") >= 0 || string.indexOf("\\") >= 0 || string.indexOf("..") >= 0 || string.endsWith(".")) {
            throw new IllegalArgumentException("not simple name: " + string);
        }
        this.dir = string;
    }

    public boolean isValid() {
        return this.layerName != null && this.layerName.trim().length() > 0 && this.dir != null && this.dir.trim().length() > 0 && this.partsCategory != null && this.colorGroup != null;
    }

    public Layer toLayer() {
        if (!this.isValid()) {
            return null;
        }
        ColorGroup colorGroup = this.getColorGroup().convert();
        return new Layer(this.getLayerId(), this.getLayerName(), this.getOrder(), colorGroup, colorGroup.isEnabled(), this.getDir());
    }
}

