/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPartsImageSet
extends AbstractCollection<AbstractCharacterDataArchiveFile.PartsImageContent> {
    private String partsName;
    private ArrayList<AbstractCharacterDataArchiveFile.PartsImageContent> contentSet = new ArrayList();
    private Long lastModified;
    private int width;
    private int height;
    private boolean unmatchedSize;
    private boolean alphaColor;
    private Collection<PartsCategory> partsCategories;
    private Long lastModifiedAtCurrentProfile;
    private boolean checked;

    public ImportPartsImageSet(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.partsName = string;
    }

    public String getPartsName() {
        return this.partsName;
    }

    @Override
    public int size() {
        return this.contentSet.size();
    }

    @Override
    public Iterator<AbstractCharacterDataArchiveFile.PartsImageContent> iterator() {
        return this.contentSet.iterator();
    }

    @Override
    public boolean add(AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent) {
        if (partsImageContent == null) {
            throw new IllegalArgumentException();
        }
        if (!this.partsName.equals(partsImageContent.getPartsName())) {
            throw new IllegalArgumentException();
        }
        this.lastModified = null;
        return this.contentSet.add(partsImageContent);
    }

    public int getWidth() {
        this.recheck();
        return this.width;
    }

    public int getHeight() {
        this.recheck();
        return this.height;
    }

    public boolean isUnmatchedSize() {
        this.recheck();
        return this.unmatchedSize;
    }

    public boolean isAlphaColor() {
        this.recheck();
        return this.alphaColor;
    }

    public long lastModified() {
        this.recheck();
        return this.lastModified;
    }

    public Collection<PartsCategory> getPartsCategories() {
        this.recheck();
        return this.partsCategories;
    }

    protected void recheck() {
        if (this.lastModified != null) {
            return;
        }
        long l = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = !this.contentSet.isEmpty();
        HashSet<PartsCategory> hashSet = new HashSet<PartsCategory>();
        for (AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent : this.contentSet) {
            PNGFileImageHeader pNGFileImageHeader = partsImageContent.getPngFileImageHeader();
            n = Math.max(n, pNGFileImageHeader.getWidth());
            n2 = Math.max(n2, pNGFileImageHeader.getHeight());
            n3 = Math.max(n3, pNGFileImageHeader.getWidth());
            n4 = Math.max(n4, pNGFileImageHeader.getHeight());
            if (pNGFileImageHeader.getColorType() != 6 && !pNGFileImageHeader.hasTransparencyInformation()) {
                bl = false;
            }
            for (AbstractCharacterDataArchiveFile.CategoryLayerPair categoryLayerPair : partsImageContent.getCategoryLayerPairs()) {
                hashSet.add(categoryLayerPair.getPartsCategory());
            }
            long l2 = partsImageContent.lastModified();
            l = Math.max(l, l2);
        }
        this.lastModified = l;
        this.width = n;
        this.height = n2;
        this.unmatchedSize = n3 != n || n4 != n2;
        this.alphaColor = bl;
        this.partsCategories = Collections.unmodifiableCollection(hashSet);
    }

    public Long getLastModifiedAtCurrentProfile() {
        return this.lastModifiedAtCurrentProfile;
    }

    public void setLastModifiedAtCurrentProfile(Long l) {
        this.lastModifiedAtCurrentProfile = l;
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
    }

    public boolean isChecked() {
        return this.checked;
    }
}

