/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.CharacterDataFileReaderWriterFactory;
import charactermanaj.model.io.CharacterDataWriter;
import charactermanaj.ui.ArchiveFileDialog;
import charactermanaj.ui.ExportInformationPanel;
import charactermanaj.ui.ExportPartsSelectPanel;
import charactermanaj.ui.ExportPresetSelectPanel;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/exportwizdialog";
    protected static ArchiveFileDialog archiveFileDialog = new ArchiveFileDialog();
    private JPanel activePanel;
    private AbstractAction actNext;
    private AbstractAction actPrev;
    private AbstractAction actFinish;
    private ExportInformationPanel basicPanel;
    private ExportPartsSelectPanel partsSelectPanel;
    private ExportPresetSelectPanel presetSelectPanel;
    private CharacterData source;

    public static File getLastUsedDir() {
        return archiveFileDialog.getLastUSedDir();
    }

    public static void setLastUsedDir(File file) {
        archiveFileDialog.setLastUSedDir(file);
    }

    public ExportWizardDialog(JFrame jFrame, CharacterData characterData, BufferedImage bufferedImage) {
        super((Frame)jFrame, true);
        this.initComponent(jFrame, characterData, bufferedImage);
    }

    public ExportWizardDialog(JDialog jDialog, CharacterData characterData, BufferedImage bufferedImage) {
        super((Dialog)jDialog, true);
        this.initComponent(jDialog, characterData, bufferedImage);
    }

    private void initComponent(Component component, CharacterData characterData, BufferedImage bufferedImage) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.source = characterData;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExportWizardDialog.this.onClose();
            }
        });
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(properties.getProperty("title"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        final JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        final CardLayout cardLayout = new CardLayout(5, 5);
        jPanel.setLayout(cardLayout);
        container.add((Component)jPanel, "Center");
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ExportWizardDialog.this.onComponentShown((JPanel)componentEvent.getComponent());
            }
        };
        this.actNext = new AbstractAction(properties.getProperty("btn.next")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.next(jPanel);
            }
        };
        this.actPrev = new AbstractAction(properties.getProperty("btn.prev")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.previous(jPanel);
            }
        };
        this.actFinish = new AbstractAction(properties.getProperty("btn.finish")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportWizardDialog.this.onFinish();
            }
        };
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportWizardDialog.this.onClose();
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ExportWizardDialog.this.updateBtnPanelState();
            }
        };
        ChangeListener changeListener2 = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ExportWizardDialog.this.updatePanelStatus();
            }
        };
        this.basicPanel = new ExportInformationPanel(characterData, bufferedImage);
        this.basicPanel.addComponentListener(componentAdapter);
        this.basicPanel.addChangeListener(changeListener);
        this.basicPanel.addChangeListener(changeListener2);
        jPanel.add((Component)this.basicPanel, "basicPanel");
        this.partsSelectPanel = new ExportPartsSelectPanel(characterData);
        this.partsSelectPanel.addComponentListener(componentAdapter);
        this.partsSelectPanel.addChangeListener(changeListener);
        jPanel.add((Component)this.partsSelectPanel, "partsSelectPanel");
        this.presetSelectPanel = new ExportPresetSelectPanel(this.partsSelectPanel, this.basicPanel, characterData.getPartsSets().values(), characterData.getDefaultPartsSetId());
        this.presetSelectPanel.addComponentListener(componentAdapter);
        this.presetSelectPanel.addChangeListener(changeListener);
        jPanel.add((Component)this.presetSelectPanel, "presetSelectPanel");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 45));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        this.actPrev.setEnabled(false);
        this.actNext.setEnabled(false);
        this.actFinish.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 2 : 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JButton(this.actPrev), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 3 : 2;
        gridBagConstraints.gridy = 0;
        JButton jButton = new JButton(this.actNext);
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 4 : 3;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)new JButton(this.actFinish), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 1 : 4;
        gridBagConstraints.gridy = 0;
        JButton jButton2 = new JButton(abstractAction);
        jPanel2.add((Component)jButton2, gridBagConstraints);
        container.add((Component)jPanel2, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeExportWizDialog");
        actionMap.put("closeExportWizDialog", abstractAction);
        this.setSize(500, 500);
        this.setLocationRelativeTo(component);
        cardLayout.first(jPanel);
        this.updateBtnPanelState();
        this.updatePanelStatus();
    }

    protected void onComponentShown(JPanel jPanel) {
        this.activePanel = jPanel;
        this.updateBtnPanelState();
    }

    protected void updatePanelStatus() {
        this.partsSelectPanel.setEnabled(this.basicPanel.isExportPartsImages());
        this.presetSelectPanel.setEnabled(this.basicPanel.isExportPresets());
    }

    protected void updateBtnPanelState() {
        this.actPrev.setEnabled(this.activePanel != null && this.activePanel != this.basicPanel);
        this.actNext.setEnabled(this.activePanel != null && this.activePanel != this.presetSelectPanel);
        this.actFinish.setEnabled(this.isComplete());
    }

    protected void checkMissingParts(Collection<PartsSet> collection) {
        if (collection == null) {
            collection = this.presetSelectPanel.getSelectedPresets();
        }
        this.partsSelectPanel.checkMissingPartsList(collection);
    }

    protected boolean isComplete() {
        if (this.basicPanel.isExportSubset() && !this.basicPanel.isExportPartsImages() && !this.basicPanel.isExportPresets() && !this.basicPanel.isExportSamplePicture()) {
            return false;
        }
        if (this.basicPanel.isExportPartsImages() && this.partsSelectPanel.getSelectedCount() == 0) {
            return false;
        }
        return !this.basicPanel.isExportPresets() || this.presetSelectPanel.getSelectedCount() != 0;
    }

    protected void onClose() {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, properties.getProperty("confirm.close"), properties.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        if (!this.isComplete()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        try {
            File file = archiveFileDialog.showSaveDialog(this);
            if (file == null) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.doExport(file);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            JOptionPane.showMessageDialog(this, properties.getProperty("complete"));
            this.dispose();
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExport(File file) throws IOException {
        CharacterDataFileReaderWriterFactory characterDataFileReaderWriterFactory = CharacterDataFileReaderWriterFactory.getInstance();
        CharacterDataWriter characterDataWriter = characterDataFileReaderWriterFactory.createWriter(file);
        try {
            Object object;
            Object object2;
            CharacterData characterData = this.source.duplicateBasicInfo(false);
            characterData.clearPartsSets(false);
            boolean bl = this.basicPanel.isExportPresets();
            boolean bl2 = this.basicPanel.isExportSamplePicture();
            boolean bl3 = true;
            boolean bl4 = this.basicPanel.isExportPartsImages();
            boolean bl5 = this.basicPanel.isExportSubset();
            characterData.setAuthor(this.basicPanel.getAuthor());
            characterData.setDescription(this.basicPanel.getDescription());
            Properties properties = new Properties();
            properties.setProperty("EXPORT_PRESETS", Boolean.toString(bl));
            properties.setProperty("EXPORT_SAMPLE_PICTURE", Boolean.toString(bl2));
            properties.setProperty("EXPORT_CHARACTER_DATA", Boolean.toString(bl3));
            properties.setProperty("EXPORT_SUBSET", Boolean.toString(bl5));
            properties.setProperty("EXPORT_PARTS_IMAGES", Boolean.toString(bl4));
            properties.setProperty("EXPORT_TIMESTAMP", Long.toString(System.currentTimeMillis()));
            characterDataWriter.writeExportProp(properties);
            if (bl) {
                object2 = new HashSet();
                for (PartsSet object3 : this.presetSelectPanel.getSelectedPresets()) {
                    ((HashSet)object2).add(object3.getPartsSetId());
                    characterData.addPartsSet(object3);
                }
                object = this.presetSelectPanel.getDefaultPresetId();
                if (((HashSet)object2).contains(object)) {
                    characterData.setDefaultPartsSetId((String)object);
                }
            }
            characterDataWriter.writeCharacterData(characterData);
            object2 = characterData.getDescription();
            if (object2 != null && ((String)object2).trim().length() > 0) {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                printWriter.println("exported by CharacterManaJ (version 1.0)");
                printWriter.println();
                printWriter.println((String)object2);
                printWriter.close();
                characterDataWriter.writeTextUTF16LE("readme.txt", ((StringWriter)object).toString());
            }
            if (bl2) {
                object = null;
                object = this.basicPanel.getSamplePicture();
                if (object != null) {
                    characterDataWriter.writeSamplePicture((BufferedImage)object);
                }
            }
            if (bl4) {
                characterDataWriter.writePartsImages(this.partsSelectPanel.getSelectedParts());
            }
        }
        finally {
            characterDataWriter.close();
        }
    }
}

