/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.ui.AbstractImportPanel;
import charactermanaj.ui.ExportInformationResolver;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ExportInformationPanel
extends AbstractImportPanel
implements ExportInformationResolver {
    private static final long serialVersionUID = 1L;
    private BufferedImage samplePicture;
    private SamplePicturePanel sampleImagePanel;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private JCheckBox chkPartsImages;
    private JCheckBox chkPresets;
    private JCheckBox chkSampleImage;
    private JCheckBox chkExportSubset;

    protected ExportInformationPanel(CharacterData characterData, BufferedImage bufferedImage) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.setName("basicPanel");
        this.samplePicture = bufferedImage;
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(properties.getProperty("basic.contentsSpec"))));
        BoxLayout boxLayout = new BoxLayout(jPanel, 3);
        jPanel.setLayout(boxLayout);
        JCheckBox jCheckBox = new JCheckBox(properties.getProperty("characterdef"));
        this.chkPartsImages = new JCheckBox(properties.getProperty("basic.chk.partsImages"));
        this.chkPresets = new JCheckBox(properties.getProperty("basic.chk.presets"));
        this.chkSampleImage = new JCheckBox(properties.getProperty("basic.chk.samplePicture"));
        jCheckBox.setEnabled(false);
        jCheckBox.setSelected(true);
        jPanel.add(jCheckBox);
        jPanel.add(this.chkPartsImages);
        jPanel.add(this.chkPresets);
        jPanel.add(this.chkSampleImage);
        JPanel jPanel2 = new JPanel();
        Dimension dimension = new Dimension(300, 200);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(properties.getProperty("basic.comment"))));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.chkExportSubset = new JCheckBox(properties.getProperty("exportSubset"));
        jPanel2.add((Component)this.chkExportSubset, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("author"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        this.txtAuthor = new JTextField();
        jPanel2.add((Component)this.txtAuthor, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("description"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.txtDescription = new JTextArea();
        this.txtDescription.setFont(this.getFont());
        jPanel2.add((Component)new JScrollPane(this.txtDescription), gridBagConstraints);
        this.sampleImagePanel = new SamplePicturePanel(bufferedImage);
        this.sampleImagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(properties.getProperty("basic.sampleImage"))));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)this.sampleImagePanel, gridBagConstraints);
        this.loadBasicInfo(characterData);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportInformationPanel.this.updateSamplePicture();
                ExportInformationPanel.this.fireChangeEvent();
            }
        };
        this.chkPartsImages.addActionListener(actionListener);
        this.chkPresets.addActionListener(actionListener);
        this.chkSampleImage.addActionListener(actionListener);
        this.chkExportSubset.addActionListener(actionListener);
    }

    protected void updateSamplePicture() {
        this.sampleImagePanel.setVisiblePicture(this.chkSampleImage.isSelected());
    }

    protected void loadBasicInfo(CharacterData characterData) {
        if (this.samplePicture == null) {
            this.chkSampleImage.setEnabled(false);
            this.chkSampleImage.setSelected(false);
            this.sampleImagePanel.setVisiblePicture(false);
        } else {
            this.chkSampleImage.setSelected(true);
            this.sampleImagePanel.setVisiblePicture(true);
        }
        this.chkPartsImages.setSelected(true);
        this.chkPresets.setSelected(true);
        String string = characterData.getAuthor();
        String string2 = characterData.getDescription();
        this.txtAuthor.setText(string == null ? "" : string);
        this.txtDescription.setText(string2 == null ? "" : string2);
        this.chkExportSubset.setSelected(true);
    }

    public BufferedImage getSamplePicture() {
        return this.samplePicture;
    }

    public boolean isExportSubset() {
        return this.chkExportSubset.isSelected();
    }

    public boolean isExportSamplePicture() {
        return this.chkSampleImage.isSelected();
    }

    public boolean isExportPartsImages() {
        return this.chkPartsImages.isSelected();
    }

    public boolean isExportPresets() {
        return this.chkPresets.isSelected();
    }

    public String getAuthor() {
        return this.txtAuthor.getText();
    }

    public String getDescription() {
        return this.txtDescription.getText();
    }
}

