/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorGroupsTableModel
extends AbstractTableModelWithComboBoxModel<ColorGroupsTableRow> {
    private static final long serialVersionUID = 2952439955567262351L;
    private static final String[] colorGroupColumnNames;
    private static final Logger logger;
    private int serialCounter = 1;

    ColorGroupsTableModel() {
    }

    @Override
    public int getColumnCount() {
        return colorGroupColumnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return colorGroupColumnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ColorGroupsTableRow colorGroupsTableRow = (ColorGroupsTableRow)this.elements.get(n);
        switch (n2) {
            case 0: {
                return colorGroupsTableRow.getLocalizedName();
            }
        }
        return "****";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ColorGroupsTableRow colorGroupsTableRow = (ColorGroupsTableRow)this.elements.get(n);
        try {
            switch (n2) {
                case 0: {
                    String string = (String)object;
                    if (string == null || string.trim().length() <= 0) break;
                    colorGroupsTableRow.setLocalizedName(string.trim());
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "value set failed. (" + n + ", " + n2 + "): " + object, exception);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isEditable();
    }

    public void addNewColorGroup() {
        String string = "cg" + UUID.randomUUID().toString();
        String string2 = "ColorGroup" + this.serialCounter++;
        ColorGroupsTableRow colorGroupsTableRow = new ColorGroupsTableRow(string, string2);
        this.addRow(colorGroupsTableRow);
    }

    static {
        logger = ApplicationLogger.getLogger();
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/profileditdialog");
        colorGroupColumnNames = new String[]{properties.getProperty("colorgroup.column.colorgroupname")};
    }
}

