/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialogTabPanel;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final PartsCategory partsCategory;
    private HashMap<Layer, ColorDialogTabPanel> tabs = new HashMap();
    private LinkedList<ColorChangeListener> listeners = new LinkedList();
    private String captionBase;
    private PartsIdentifier partsIdentifier;
    private JCheckBox chkApplyAll;

    public ColorDialog(JFrame jFrame, PartsCategory partsCategory, Collection<ColorGroup> collection) {
        super(jFrame);
        this.partsCategory = partsCategory;
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/colordialog");
        String string = properties.getProperty("colordialog.caption");
        String string2 = partsCategory.getLocalizedCategoryName();
        this.captionBase = string + string2;
        this.setTitle(this.captionBase);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorDialog.this.setVisible(false);
            }
        });
        Container container = this.getContentPane();
        JTabbedPane jTabbedPane = new JTabbedPane(1, 0);
        for (final Layer serializable2 : partsCategory.getLayers()) {
            ColorDialogTabPanel colorDialogTabPanel = new ColorDialogTabPanel(this, serializable2, collection);
            ColorChangeListener colorChangeListener = new ColorChangeListener(){
                private Semaphore semaphore = new Semaphore(1);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onColorChange(ColorChangeEvent colorChangeEvent) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorChangeEvent(serializable2);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onColorGroupChange(ColorChangeEvent colorChangeEvent) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorGroupChangeEvent(serializable2);
                            ColorDialog.this.fireColorChangeEvent(serializable2);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }
            };
            colorDialogTabPanel.addColorChangeListener(colorChangeListener);
            jTabbedPane.addTab(serializable2.getLocalizedName(), colorDialogTabPanel);
            this.tabs.put(serializable2, colorDialogTabPanel);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JButton jButton = new JButton(properties.getProperty("button.apply"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Layer layer : ColorDialog.this.getPartsCategory().getLayers()) {
                    ColorDialog.this.fireColorChangeEvent(layer);
                }
            }
        });
        jPanel.add((Component)jButton, "East");
        this.chkApplyAll = new JCheckBox(properties.getProperty("checkbox.applyAllItems"));
        this.chkApplyAll.setSelected(!partsCategory.isMultipleSelectable());
        jPanel.add((Component)this.chkApplyAll, "West");
        container.setLayout(new BorderLayout());
        container.add((Component)jTabbedPane, "Center");
        container.add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
    }

    public void adjustLocation(int n) {
        Point point = this.getParent().getLocation();
        Insets insets = this.getParent().getInsets();
        point.x += this.getParent().getWidth();
        point.y += n * insets.top;
        this.setLocation(point);
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public boolean isSyncColorGroup(Layer layer) {
        ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
        if (colorDialogTabPanel == null) {
            return false;
        }
        return colorDialogTabPanel.isSyncColorGroup();
    }

    public void setSyncColorGroup(Layer layer, boolean bl) {
        ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
        if (colorDialogTabPanel != null) {
            colorDialogTabPanel.setSyncColorGroup(bl);
        }
    }

    public void setColorConvertParameters(Map<Layer, ColorConvertParameter> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorConvertParameter colorConvertParameter = map.get(layer);
            if (colorConvertParameter == null) {
                colorConvertParameter = new ColorConvertParameter();
            }
            this.setColorConvertParameter(layer, colorConvertParameter);
        }
    }

    public void setPartsIdentifier(PartsIdentifier partsIdentifier) {
        this.partsIdentifier = partsIdentifier;
        if (partsIdentifier == null) {
            this.setTitle(this.captionBase);
        } else {
            this.setTitle(this.captionBase + "(" + partsIdentifier.getLocalizedPartsName() + ")");
        }
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public boolean isApplyAll() {
        return this.chkApplyAll.isSelected();
    }

    public Map<Layer, ColorConvertParameter> getColorConvertParameters() {
        HashMap<Layer, ColorConvertParameter> hashMap = new HashMap<Layer, ColorConvertParameter>();
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
            ColorConvertParameter colorConvertParameter = colorDialogTabPanel.getColorConvertParameter();
            hashMap.put(layer, colorConvertParameter);
        }
        return hashMap;
    }

    public void setColorConvertParameter(Layer layer, ColorConvertParameter colorConvertParameter) {
        if (layer == null || colorConvertParameter == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
        if (colorDialogTabPanel == null) {
            throw new IllegalArgumentException("layer not found. " + layer + "/tabs=" + this.tabs);
        }
        colorDialogTabPanel.setColorConvertParameter(colorConvertParameter);
    }

    public ColorConvertParameter getColorConvertParameter(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
        if (colorDialogTabPanel == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return colorDialogTabPanel.getColorConvertParameter();
    }

    public ColorGroup getColorGroup(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
        if (colorDialogTabPanel == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return colorDialogTabPanel.getColorGroup();
    }

    public void setColorGroup(Layer layer, ColorGroup colorGroup) {
        if (layer == null || colorGroup == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel colorDialogTabPanel = this.tabs.get(layer);
        if (colorDialogTabPanel != null) {
            colorDialogTabPanel.setColorGroup(colorGroup);
        }
    }

    public void addColorChangeListener(ColorChangeListener colorChangeListener) {
        if (colorChangeListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(colorChangeListener);
    }

    public void removeColorChangeListener(ColorChangeListener colorChangeListener) {
        this.listeners.remove(colorChangeListener);
    }

    protected void fireColorChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorChangeEvent colorChangeEvent = new ColorChangeEvent(this, layer);
        for (ColorChangeListener colorChangeListener : this.listeners) {
            colorChangeListener.onColorChange(colorChangeEvent);
        }
    }

    protected void fireColorGroupChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorChangeEvent colorChangeEvent = new ColorChangeEvent(this, layer);
        for (ColorChangeListener colorChangeListener : this.listeners) {
            colorChangeListener.onColorGroupChange(colorChangeEvent);
        }
    }

    @Override
    public String toString() {
        return "ColorDialog(partsCategory:" + this.partsCategory + ")";
    }
}

