/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoriesTableRow
implements Comparable<CategoriesTableRow> {
    private int order;
    private String categoryId;
    private String localizedCategoryName;
    private boolean multipleSelectable;
    private int visibleRows;
    private ArrayList<Layer> layers = new ArrayList();

    public CategoriesTableRow(int n, String string, String string2, boolean bl, int n2, Layer[] layerArray) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (layerArray == null) {
            layerArray = new Layer[]{};
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = string;
        }
        this.order = n;
        this.categoryId = string.trim();
        this.localizedCategoryName = string2.trim();
        this.multipleSelectable = bl;
        this.layers.addAll(Arrays.asList(layerArray));
        this.visibleRows = n2;
    }

    public CategoriesTableRow(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.order = partsCategory.getOrder();
        this.categoryId = partsCategory.getCategoryId();
        this.localizedCategoryName = partsCategory.getLocalizedCategoryName();
        this.multipleSelectable = partsCategory.isMultipleSelectable();
        this.layers.addAll(partsCategory.getLayers());
        this.visibleRows = partsCategory.getVisibleRows();
    }

    public PartsCategory convert() {
        return new PartsCategory(this.order, this.categoryId, this.localizedCategoryName, this.multipleSelectable, this.visibleRows, this.layers.toArray(new Layer[this.layers.size()]));
    }

    @Override
    public int compareTo(CategoriesTableRow categoriesTableRow) {
        int n = this.order - categoriesTableRow.getOrder();
        if (n == 0) {
            n = this.localizedCategoryName.compareTo(this.localizedCategoryName);
        }
        if (n == 0) {
            n = this.categoryId.compareTo(categoriesTableRow.getCategoryId());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof CategoriesTableRow) {
            return this.categoryId.equals(((CategoriesTableRow)object).getCategoryId());
        }
        return false;
    }

    public static boolean equals(CategoriesTableRow categoriesTableRow, CategoriesTableRow categoriesTableRow2) {
        if (categoriesTableRow == categoriesTableRow2) {
            return true;
        }
        if (categoriesTableRow == null || categoriesTableRow2 == null) {
            return false;
        }
        return categoriesTableRow.equals(categoriesTableRow2);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    public void setMultipleSelectable(boolean bl) {
        this.multipleSelectable = bl;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int n) {
        this.visibleRows = n;
    }

    public boolean hasLayer(Layer layer) {
        if (layer != null) {
            for (Layer layer2 : this.layers) {
                if (!Layer.equals(layer2, layer)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Layer> getLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public void setLayers(Collection<Layer> collection) {
        this.layers.clear();
        if (collection != null) {
            this.layers.addAll(collection);
        }
    }

    public Layer getLayer(String string) {
        if (string == null) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getId().equals(string)) continue;
            return layer;
        }
        return null;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getLocalizedCategoryName() {
        return this.localizedCategoryName;
    }

    public void setLocalizedCategoryName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.localizedCategoryName = string.trim();
    }

    public int hashCode() {
        return this.categoryId.hashCode();
    }

    public String toString() {
        return this.getLocalizedCategoryName();
    }
}

