/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.ui.AppConfigRowModel;
import charactermanaj.ui.AppConfigTableModel;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;

public class AppConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AppConfigTableModel appConfigTableModel;
    private JTable appConfigTable;

    public AppConfigDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppConfigDialog.this.onClose();
            }
        });
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
        this.setTitle(properties.getProperty("title"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 45));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("btn.apply")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                AppConfigDialog.this.onUpdate();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(properties.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                AppConfigDialog.this.onClose();
            }
        };
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 2 : 1;
        gridBagConstraints.weightx = 0.0;
        JButton jButton = new JButton(abstractAction);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 1 : 2;
        gridBagConstraints.weightx = 0.0;
        JButton jButton2 = new JButton(abstractAction2);
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.add((Component)jPanel, "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(jFrame);
        JLabel jLabel = new JLabel(properties.getProperty("caution"));
        jLabel.setForeground(Color.red);
        container.add((Component)jLabel, "North");
        this.appConfigTableModel = new AppConfigTableModel();
        Properties properties2 = AppConfig.getInstance().getProperties();
        this.appConfigTableModel.initModel(properties2);
        AppConfig appConfig = AppConfig.getInstance();
        final Color color = appConfig.getInvalidBgColor();
        this.appConfigTable = new JTable(this.appConfigTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                AppConfigRowModel appConfigRowModel = (AppConfigRowModel)AppConfigDialog.this.appConfigTableModel.getRow(n);
                if (appConfigRowModel.isRejected()) {
                    component.setBackground(color);
                } else if (this.isCellSelected(n, n2)) {
                    component.setBackground(this.getSelectionBackground());
                } else {
                    component.setBackground(this.getBackground());
                }
                return component;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                int n2 = this.columnAtPoint(mouseEvent.getPoint());
                if (n2 == 0) {
                    AppConfigRowModel appConfigRowModel = (AppConfigRowModel)AppConfigDialog.this.appConfigTableModel.getRow(n);
                    return appConfigRowModel.getDisplayName();
                }
                return super.getToolTipText(mouseEvent);
            }
        };
        this.appConfigTable.setAutoResizeMode(3);
        this.appConfigTable.setShowGrid(true);
        this.appConfigTable.setGridColor(AppConfig.getInstance().getGridColor());
        this.appConfigTableModel.adjustColumnModel(this.appConfigTable.getColumnModel());
        JScrollPane jScrollPane = new JScrollPane(this.appConfigTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(properties.getProperty("table.caption")));
        jScrollPane.setVerticalScrollBarPolicy(22);
        container.add((Component)jScrollPane, "Center");
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeAppConfigDialog");
        actionMap.put("closeAppConfigDialog", abstractAction2);
    }

    protected void onClose() {
        Properties properties;
        if (this.appConfigTableModel.isModified() && JOptionPane.showConfirmDialog(this, (properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog")).getProperty("confirm.close"), properties.getProperty("confirm.close.caption"), 0, 3) != 0) {
            return;
        }
        this.dispose();
    }

    protected void onUpdate() {
        if (this.appConfigTable.isEditing()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
        Properties properties2 = this.appConfigTableModel.getProperties();
        Set<String> set = AppConfig.checkProperties(properties2);
        if (!set.isEmpty()) {
            this.appConfigTableModel.setRejectNames(set);
            JOptionPane.showMessageDialog(this, properties.getProperty("error.message"), properties.getProperty("error.caption"), 0);
            return;
        }
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.update(properties2);
        try {
            appConfig.saveConfig();
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
        String string = properties.getProperty("caution");
        JOptionPane.showMessageDialog(this, string);
        this.dispose();
    }
}

