/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import charactermanaj.util.ApplicationLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public class PartsImageDirectoryWatchAgent
implements Runnable {
    private static final Logger logger = ApplicationLogger.getLogger();
    private final CharacterData characterData;
    private final File baseDir;
    private volatile boolean stopFlag;
    private int dirWatchInterval;
    private Thread thread;
    private final Semaphore semaphore = new Semaphore(1);
    private volatile Long signature;
    private volatile int itemCount;
    private volatile long maxLastModified;
    private LinkedList<PartsImageDirectoryWatchListener> listeners = new LinkedList();

    public PartsImageDirectoryWatchAgent(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URL uRL = characterData.getDocBase();
        File file = null;
        if (uRL != null && uRL.getProtocol().equals("file")) {
            file = new File(uRL.getPath()).getParentFile();
        }
        this.characterData = characterData;
        this.baseDir = file;
        this.dirWatchInterval = AppConfig.getInstance().getDirWatchInterval();
    }

    public CharacterData getCharcterData() {
        return this.characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PartsImageDirectoryWatchAgent partsImageDirectoryWatchAgent = this;
        synchronized (partsImageDirectoryWatchAgent) {
            if (this.thread != null) {
                throw new IllegalStateException();
            }
            this.stopFlag = false;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        boolean bl = false;
        PartsImageDirectoryWatchAgent partsImageDirectoryWatchAgent = this;
        synchronized (partsImageDirectoryWatchAgent) {
            if (this.thread != null && this.thread.isAlive()) {
                this.stopFlag = true;
                this.thread.interrupt();
                try {
                    this.thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.INFO, "stop request interrupted.", interruptedException);
                }
                bl = true;
            }
            this.thread = null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.log(Level.FINE, "watch-dir thead started.");
        while (!this.stopFlag) {
            try {
                Thread.sleep(this.dirWatchInterval);
                this.semaphore.acquire();
                try {
                    this.watch();
                }
                finally {
                    this.semaphore.release();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.FINE, "watch-dir thead interrupted.", interruptedException);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "PartsImageDirectoryWatchAgent failed.", exception);
            }
        }
        logger.log(Level.INFO, "watch-dir thead stopped.");
    }

    public void watch() throws InterruptedException {
        if (this.baseDir == null || !this.baseDir.exists() || !this.baseDir.isDirectory()) {
            return;
        }
        int n = 0;
        long l = 0L;
        long l2 = System.currentTimeMillis() + (long)this.dirWatchInterval;
        CRC32 cRC32 = new CRC32();
        for (PartsCategory partsCategory : this.characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                String string = layer.getDir();
                File file = new File(this.baseDir, string);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (file.exists() && file.isDirectory()) {
                    for (File file2 : file.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isFile() && file.getName().toLowerCase().endsWith(".png");
                        }
                    })) {
                        if (Thread.interrupted() || this.stopFlag) {
                            throw new InterruptedException();
                        }
                        ++n;
                        long l3 = file2.lastModified();
                        if (l3 <= l2) {
                            l = Math.max(l, l3);
                        }
                        arrayList.add(file2.getName() + ":" + l3);
                    }
                    Collections.sort(arrayList);
                }
                for (String string2 : arrayList) {
                    cRC32.update(string2.getBytes());
                }
            }
        }
        long l4 = cRC32.getValue();
        if (this.signature != null && (this.signature != l4 || this.itemCount != n || this.maxLastModified != l)) {
            this.fireWatchEvent();
        }
        this.signature = l4;
        this.maxLastModified = l;
        this.itemCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (Thread.currentThread() == this.thread) {
            throw new IllegalStateException();
        }
        PartsImageDirectoryWatchAgent partsImageDirectoryWatchAgent = this;
        synchronized (partsImageDirectoryWatchAgent) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        try {
            this.semaphore.acquire();
            try {
                this.signature = null;
                this.watch();
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener partsImageDirectoryWatchListener) {
        if (partsImageDirectoryWatchListener != null) {
            LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.add(partsImageDirectoryWatchListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener partsImageDirectoryWatchListener) {
        if (partsImageDirectoryWatchListener != null) {
            LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.remove(partsImageDirectoryWatchListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWatchEvent() {
        PartsImageDirectoryWatchListener[] partsImageDirectoryWatchListenerArray;
        Serializable serializable = this.listeners;
        synchronized (serializable) {
            partsImageDirectoryWatchListenerArray = this.listeners.toArray(new PartsImageDirectoryWatchListener[this.listeners.size()]);
        }
        serializable = new PartsImageDirectoryWatchEvent(this);
        for (PartsImageDirectoryWatchListener partsImageDirectoryWatchListener : partsImageDirectoryWatchListenerArray) {
            partsImageDirectoryWatchListener.detectPartsImageChange((PartsImageDirectoryWatchEvent)serializable);
        }
    }
}

