/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsFiles;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsDataLoader;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePartsDataLoader
implements PartsDataLoader {
    private File baseDir;

    public FilePartsDataLoader(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.baseDir = file;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> load(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        HashMap<PartsIdentifier, PartsSpec> hashMap = new HashMap<PartsIdentifier, PartsSpec>();
        for (Layer layer : partsCategory.getLayers()) {
            File file = new File(this.baseDir, layer.getDir());
            if (!file.exists() || !file.isDirectory()) continue;
            for (File file2 : file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isFile()) {
                        String string = file.getPath().toLowerCase();
                        return string.endsWith(".png");
                    }
                    return false;
                }
            })) {
                PartsIdentifier partsIdentifier;
                PartsSpec partsSpec;
                String string = file2.getName();
                int n = string.lastIndexOf(".");
                if (n > 0) {
                    string = string.substring(0, n);
                }
                if ((partsSpec = (PartsSpec)hashMap.get(partsIdentifier = new PartsIdentifier(partsCategory, string, string))) == null) {
                    partsSpec = this.createPartsSpec(partsIdentifier);
                    hashMap.put(partsIdentifier, partsSpec);
                }
                PartsFiles partsFiles = partsSpec.getPartsFiles();
                partsFiles.put(layer, new FileImageResource(file2));
            }
        }
        return hashMap;
    }

    protected PartsSpec createPartsSpec(PartsIdentifier partsIdentifier) {
        return new PartsSpec(partsIdentifier);
    }
}

