/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class CharacterDataZipArchiveFile
extends AbstractCharacterDataArchiveFile {
    protected ZipFile zipFile;

    public void close() throws IOException {
        this.zipFile.close();
    }

    public CharacterDataZipArchiveFile(File file) throws IOException {
        super(file);
        AppConfig appConfig = AppConfig.getInstance();
        String string = appConfig.getZipNameEncoding();
        this.zipFile = new ZipFile(file, string);
        this.load();
    }

    private void load() {
        Enumeration enumeration = this.zipFile.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            this.addEntry(new ZipFileContent(zipEntry));
        }
        this.searchRootPrefix();
    }

    protected class ZipFileContent
    implements AbstractCharacterDataArchiveFile.FileContent {
        private ZipEntry entry;

        protected ZipFileContent(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        public String getEntryName() {
            return this.entry.getName();
        }

        public long lastModified() {
            return this.entry.getTime();
        }

        public InputStream openStream() throws IOException {
            return CharacterDataZipArchiveFile.this.zipFile.getInputStream(this.entry);
        }
    }
}

