/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.MainFrame;
import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterDataPersistent {
    public static final String CONFIG_FILE = "character.xml";
    private static final Logger logger = ApplicationLogger.getLogger();
    public static final String SAMPLE_IMAGE_FILENAME = "preview.png";
    public static final String VERSION_SIG_1_0 = "1.0";
    public static final String NS = "http://com.exmaple/charactermanaj";
    private static final String CHARACTER_XML_SCHEMA = "/schema/character.xsd";
    private static final String PARTSSET_XML_SCHEMA = "/schema/partsset.xsd";
    private static final String DEFAULT_CHARACTER_XML = "/schema/character.xml";
    public static final ProfileListErrorHandler DEFAULT_ERROR_HANDLER = new ProfileListErrorHandler(){

        public void occureException(File file, Throwable throwable) {
            logger.log(Level.WARNING, "invalid profile. :" + file, throwable);
        }
    };
    private HashMap<String, Schema> schemaMap = new HashMap();
    private static final ErrorHandler errorHandler = new ErrorHandler(){

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    };
    private static final CharacterDataPersistent singleton = new CharacterDataPersistent();

    private CharacterDataPersistent() {
    }

    public static CharacterDataPersistent getInstance() {
        return singleton;
    }

    public void createProfile(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        String string = characterData.getId();
        if (string == null || string.trim().length() == 0) {
            throw new IOException("missing character-id:" + characterData);
        }
        AppConfig appConfig = AppConfig.getInstance();
        File file = appConfig.getUserCharactersDir();
        file.mkdirs();
        File file2 = null;
        String string2 = "";
        int n = 0;
        while ((file2 = new File(file, characterData.getId() + string2)).exists()) {
            if (n > 20) {
                throw new IOException("character directory conflict.:" + file2);
            }
            string2 = "." + UUID.randomUUID().toString();
            ++n;
        }
        file2.mkdirs();
        File file3 = new File(file2, CONFIG_FILE);
        if (file3.exists() && !file3.isFile()) {
            throw new IOException("character.xml is not a regular file.:" + file3);
        }
        if (file3.exists() && !file3.canWrite()) {
            throw new IOException("character.xml is not writable.:" + file3);
        }
        URL uRL = file3.toURL();
        characterData.setDocBase(uRL);
        if (characterData.getRev() == null) {
            characterData.setRev("rev" + UUID.randomUUID());
        }
        this.saveCharacterDataToXML(characterData);
        this.preparePartsDir(characterData);
    }

    public void updateProfile(CharacterData characterData, boolean bl) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.canWrite()) {
            throw new IOException("protected profile: " + characterData);
        }
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        if (bl) {
            characterData.setRev("rev" + UUID.randomUUID());
        }
        this.saveCharacterDataToXML(characterData);
        this.preparePartsDir(characterData);
    }

    protected void preparePartsDir(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.canWrite()) {
            throw new IOException("protected profile: " + characterData);
        }
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        URL uRL = characterData.getDocBase();
        if (!uRL.getProtocol().equals("file")) {
            throw new IOException("not file protocol: " + uRL);
        }
        File file = new File(uRL.getFile());
        File file2 = file.getParentFile();
        file2.mkdirs();
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                String string = layer.getDir();
                if (string == null) continue;
                File file3 = new File(file2, layer.getDir());
                file3.mkdirs();
            }
        }
    }

    public List<CharacterData> listProfiles(ProfileListErrorHandler profileListErrorHandler) {
        AppConfig appConfig = AppConfig.getInstance();
        File[] fileArray = new File[]{appConfig.getSystemCharactersDir(), appConfig.getUserCharactersDir()};
        ArrayList<CharacterData> arrayList = new ArrayList<CharacterData>();
        for (File file : fileArray) {
            if (file == null || !file.exists() || !file.isDirectory()) continue;
            for (File file2 : file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    boolean bl;
                    boolean bl2 = bl = file.isDirectory() && !file.getName().startsWith(".");
                    if (bl) {
                        File file2 = new File(file, CharacterDataPersistent.CONFIG_FILE);
                        bl = file2.exists() && file2.canRead();
                    }
                    return bl;
                }
            })) {
                File file3 = new File(file2, CONFIG_FILE);
                if (!file3.exists()) continue;
                try {
                    File file4 = new File(file2, CONFIG_FILE);
                    CharacterData characterData = this.loadProfile(file4.toURL());
                    arrayList.add(characterData);
                }
                catch (Exception exception) {
                    if (profileListErrorHandler == null) continue;
                    profileListErrorHandler.occureException(file2, exception);
                }
            }
        }
        Collections.sort(arrayList, CharacterData.SORT_DISPLAYNAME);
        return Collections.unmodifiableList(arrayList);
    }

    protected UserData getCharacterDataCacheUserFile(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = uRL.getFile().split("/");
        String string = stringArray[stringArray.length - 1];
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        return userDataFactory.getMangledNamedUserData(uRL, string + "-cache.ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData loadProfile(URL uRL) throws IOException {
        long l;
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        URLConnection uRLConnection = uRL.openConnection();
        try {
            l = uRLConnection.getLastModified();
        }
        finally {
            uRLConnection.getInputStream().close();
            uRLConnection = null;
        }
        UserData userData = this.getCharacterDataCacheUserFile(uRL);
        if (userData.exists() && l > 0L && userData.lastModified() >= l) {
            try {
                CharacterData characterData = (CharacterData)userData.load();
                URL uRL2 = characterData.getDocBase();
                if (uRL2 == null || !uRL.sameFile(uRL2)) {
                    throw new IOException("docBase mismatch. actual=" + uRL2 + "/expected=" + uRL);
                }
                return characterData;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "cached character.xml loading failed.: " + uRL, exception);
            }
        }
        CharacterData characterData = this.loadCharacterDataFromXML(uRL);
        try {
            userData.save(characterData);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "cached character.xml creation failed.: " + uRL, exception);
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData loadCharacterDataFromXML(URL uRL) throws IOException {
        CharacterData characterData;
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        InputStream inputStream = uRL.openStream();
        try {
            characterData = this.loadCharacterDataFromXML(inputStream, uRL, true);
        }
        finally {
            inputStream.close();
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData createDefaultCharacterData() {
        try {
            CharacterData characterData;
            URL uRL = this.getSchemaURL(DEFAULT_CHARACTER_XML);
            InputStream inputStream = uRL.openStream();
            try {
                characterData = this.loadCharacterDataFromXML(inputStream, null, true);
            }
            finally {
                inputStream.close();
            }
            return characterData;
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not create the default profile from application's resource", iOException);
        }
    }

    public CharacterData loadCharacterDataFromXML(InputStream inputStream, URL uRL, boolean bl) throws IOException {
        Document document;
        Serializable serializable;
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        Schema schema = this.loadSchema(CHARACTER_XML_SCHEMA);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        if (bl) {
            documentBuilderFactory.setSchema(schema);
        }
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            serializable = new ArrayList();
            ((DocumentBuilder)object).setErrorHandler(new ErrorHandler((ArrayList)serializable){
                final /* synthetic */ ArrayList val$errors;
                {
                    this.val$errors = arrayList;
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    this.val$errors.add(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    this.val$errors.add(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) throws SAXException {
                    this.val$errors.add(sAXParseException);
                }
            });
            document = ((DocumentBuilder)object).parse(inputStream);
            if (((ArrayList)serializable).size() > 0) {
                throw (SAXParseException)((ArrayList)serializable).get(0);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("JAXP Configuration Exception.", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("CharacterData read failed.");
            iOException.initCause(sAXException);
            throw iOException;
        }
        object = this.createXPath();
        serializable = new CharacterData();
        ((CharacterData)serializable).setDocBase(uRL);
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ArrayList<Object> arrayList;
            Object object6;
            Object object7;
            Node node;
            if (bl && !(node = (Node)object.evaluate("/pre:character/@version", document, XPathConstants.NODE)).getTextContent().equals(VERSION_SIG_1_0)) {
                throw new IOException("unsupported version: " + node.toString());
            }
            node = (Node)object.evaluate("/pre:character/@id", document, XPathConstants.NODE);
            String string = node.getTextContent().trim();
            ((CharacterData)serializable).setId(string);
            Node node2 = (Node)object.evaluate("/pre:character/@rev", document, XPathConstants.NODE);
            String string2 = node2.getTextContent().trim();
            ((CharacterData)serializable).setRev(string2);
            Locale locale = Locale.getDefault();
            String string3 = locale.getLanguage();
            Node node3 = (Node)object.evaluate("/pre:character/pre:name[lang('" + string3 + "')]", document, XPathConstants.NODE);
            if (node3 == null) {
                node3 = (Node)object.evaluate("/pre:character/pre:name[position() = 1]", document, XPathConstants.NODE);
            }
            String string4 = node3.getTextContent();
            ((CharacterData)serializable).setName(string4);
            Node node4 = (Node)object.evaluate("/pre:character/pre:information/pre:author[lang('" + string3 + "')]", document, XPathConstants.NODE);
            if (node4 == null) {
                node4 = (Node)object.evaluate("/pre:character/pre:information/pre:author[position() = 1]", document, XPathConstants.NODE);
            }
            ((CharacterData)serializable).setAuthor(node4 == null ? "" : node4.getTextContent().trim());
            Node node5 = (Node)object.evaluate("/pre:character/pre:information/pre:description[lang('" + string3 + "')]", document, XPathConstants.NODE);
            if (node5 == null) {
                node5 = (Node)object.evaluate("/pre:character/pre:information/pre:description[position() = 1]", document, XPathConstants.NODE);
            }
            String string5 = node5 == null ? "" : node5.getTextContent().trim();
            ((CharacterData)serializable).setDescription(string5);
            int n = Integer.parseInt(((Node)object.evaluate("/pre:character/pre:image-size/pre:width", document, XPathConstants.NODE)).getTextContent());
            int n2 = Integer.parseInt(((Node)object.evaluate("/pre:character/pre:image-size/pre:height", document, XPathConstants.NODE)).getTextContent());
            ((CharacterData)serializable).setImageSize(new Dimension(n, n2));
            XPathExpression xPathExpression = object.compile("pre:character/pre:settings/pre:entry");
            for (Node object92 : this.iterable((NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET))) {
                object7 = (Element)object92;
                object6 = object7.getAttribute("key");
                arrayList = object7.getTextContent();
                ((CharacterData)serializable).setProperty((String)object6, (String)((Object)arrayList));
            }
            ArrayList arrayList2 = new ArrayList();
            XPathExpression xPathExpression2 = object.compile("pre:display-name[lang('" + string3 + "')]");
            object7 = object.compile("pre:display-name[position() = 1]");
            object6 = object.compile("@id");
            for (Node node6 : this.iterable((NodeList)object.evaluate("/pre:character/pre:colorGroups/pre:colorGroup", document, XPathConstants.NODESET))) {
                object5 = ((Node)object6.evaluate(node6, XPathConstants.NODE)).getTextContent().trim();
                object4 = (Node)xPathExpression2.evaluate(node6, XPathConstants.NODE);
                if (object4 == null) {
                    object4 = (Node)object7.evaluate(node6, XPathConstants.NODE);
                }
                object3 = object4.getTextContent();
                object2 = new ColorGroup((String)object5, (String)object3);
                arrayList2.add(object2);
            }
            ((CharacterData)serializable).setColorGroups(arrayList2);
            arrayList = new ArrayList<Object>();
            XPathExpression xPathExpression3 = object.compile("@id");
            object5 = object.compile("@multipleSelectable");
            object4 = object.compile("pre:layers/pre:layer");
            object3 = object.compile("pre:visible-rows");
            object2 = object.compile("pre:order");
            XPathExpression xPathExpression4 = object.compile("pre:colorGroup");
            XPathExpression xPathExpression5 = object.compile("pre:dir");
            for (Node node7 : this.iterable((NodeList)object.evaluate("/pre:character/pre:categories/pre:category", document, XPathConstants.NODESET))) {
                String string6 = ((Node)xPathExpression3.evaluate(node7, XPathConstants.NODE)).getTextContent().trim();
                boolean bl2 = Boolean.parseBoolean(((Node)object5.evaluate(node7, XPathConstants.NODE)).getTextContent());
                int n3 = Integer.parseInt(((Node)object3.evaluate(node7, XPathConstants.NODE)).getTextContent());
                Node node8 = (Node)xPathExpression2.evaluate(node7, XPathConstants.NODE);
                if (node8 == null) {
                    node8 = (Node)object7.evaluate(node7, XPathConstants.NODE);
                }
                String string7 = node8.getTextContent();
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (Node node9 : this.iterable((NodeList)object4.evaluate(node7, XPathConstants.NODESET))) {
                    Object object8;
                    NamedNodeMap namedNodeMap = node9.getAttributes();
                    String string8 = namedNodeMap.getNamedItem("id").getTextContent().trim();
                    String string9 = ((Node)xPathExpression5.evaluate(node9, XPathConstants.NODE)).getTextContent();
                    int n4 = Integer.valueOf(((Node)object2.evaluate(node9, XPathConstants.NODE)).getTextContent());
                    Node node10 = (Node)xPathExpression2.evaluate(node9, XPathConstants.NODE);
                    if (node10 == null) {
                        node10 = (Node)object7.evaluate(node9, XPathConstants.NODE);
                    }
                    String string10 = node10.getTextContent();
                    Node node11 = (Node)xPathExpression4.evaluate(node9, XPathConstants.NODE);
                    ColorGroup colorGroup = null;
                    boolean bl3 = false;
                    if (node11 != null) {
                        object8 = node11.getAttributes();
                        String string11 = object8.getNamedItem("refid").getTextContent().trim();
                        colorGroup = ((CharacterData)serializable).getColorGroup(string11);
                        bl3 = Boolean.valueOf(object8.getNamedItem("init-sync").getTextContent());
                    }
                    object8 = new Layer(string8, string10, n4, colorGroup, bl3, string9);
                    arrayList3.add(object8);
                }
                PartsCategory partsCategory = new PartsCategory(arrayList.size(), string6, string7, bl2, n3, arrayList3.toArray(new Layer[arrayList3.size()]));
                arrayList.add(partsCategory);
            }
            ((CharacterData)serializable).setPartsCategories(arrayList.toArray(new PartsCategory[arrayList.size()]));
            Node node12 = (Node)object.evaluate("/pre:character/pre:presets", document, XPathConstants.NODE);
            if (node12 != null) {
                this.loadPartsSet((CharacterData)serializable, node12, true);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            IOException iOException = new IOException("CharacterData invalid format.");
            iOException.initCause(xPathExpressionException);
            throw iOException;
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCharacterDataToXML(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.canWrite()) {
            throw new IOException("protected profile: " + characterData);
        }
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        URL uRL = characterData.getDocBase();
        if (!uRL.getProtocol().equals("file")) {
            throw new IOException("not file protocol: " + uRL);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeXMLCharacterData(characterData, byteArrayOutputStream);
        }
        finally {
            byteArrayOutputStream.close();
        }
        File file = new File(uRL.getFile());
        File file2 = file.getParentFile();
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void writeXMLCharacterData(CharacterData characterData, OutputStream outputStream) throws IOException {
        Element element;
        Object object;
        Node node;
        Object object2;
        Element element2;
        Node node2;
        Element element22;
        Element element3;
        Document document;
        Object object6;
        Object object7;
        if (outputStream == null || characterData == null) {
            throw new IllegalArgumentException();
        }
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        try {
            object7 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object7).setNamespaceAware(true);
            object6 = ((DocumentBuilderFactory)object7).newDocumentBuilder();
            document = ((DocumentBuilder)object6).newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("JAXP Configuration failed.", parserConfigurationException);
        }
        object7 = document.createElementNS(NS, "character");
        object7.setAttribute("version", VERSION_SIG_1_0);
        object7.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        object7.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        object7.setAttribute("xsi:schemaLocation", "http://com.exmaple/charactermanaj character.xsd");
        object7.setAttribute("id", characterData.getId());
        object7.setAttribute("rev", characterData.getRev());
        document.appendChild((Node)object7);
        object6 = document.createElementNS(NS, "name");
        Attr attr = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        attr.setValue(string);
        object6.setAttributeNodeNS(attr);
        object6.setTextContent(characterData.getName());
        object7.appendChild((Node)object6);
        String string2 = characterData.getAuthor();
        String string3 = characterData.getDescription();
        if (string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) {
            element3 = document.createElementNS(NS, "information");
            if (string2 != null && string2.length() > 0) {
                element22 = document.createElementNS(NS, "author");
                node2 = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                node2.setValue(string);
                element22.setAttributeNodeNS((Attr)node2);
                element22.setTextContent(string2);
                element3.appendChild(element22);
            }
            if (string3 != null && string3.length() > 0) {
                string3 = string3.replace("\r\n", "\n");
                string3 = string3.replace("\r", "\n");
                element22 = document.createElementNS(NS, "description");
                node2 = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                node2.setValue(string);
                element22.setAttributeNodeNS((Attr)node2);
                element22.setTextContent(string3);
                element3.appendChild(element22);
            }
            object7.appendChild(element3);
        }
        element3 = document.createElementNS(NS, "image-size");
        element22 = document.createElementNS(NS, "width");
        element22.setTextContent(Integer.toString((int)characterData.getImageSize().getWidth()));
        node2 = document.createElementNS(NS, "height");
        node2.setTextContent(Integer.toString((int)characterData.getImageSize().getHeight()));
        element3.appendChild(element22);
        element3.appendChild(node2);
        object7.appendChild(element3);
        Element element4 = document.createElementNS(NS, "settings");
        object7.appendChild(element4);
        for (String object52 : characterData.getPropertyNames()) {
            String string4 = characterData.getProperty(object52);
            if (string4 == null) continue;
            element2 = document.createElementNS(NS, "entry");
            element2.setAttribute("key", object52);
            element2.setTextContent(string4);
            element4.appendChild(element2);
        }
        Element element5 = document.createElementNS(NS, "categories");
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            element2 = document.createElementNS(NS, "category");
            element2.setAttribute("id", partsCategory.getCategoryId());
            element2.setAttribute("multipleSelectable", partsCategory.isMultipleSelectable() ? "true" : "false");
            object2 = document.createElementNS(NS, "visible-rows");
            object2.setTextContent(Integer.toString(partsCategory.getVisibleRows()));
            element2.appendChild((Node)object2);
            Object object3 = document.createElementNS(NS, "display-name");
            node = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            node.setValue(string);
            object3.setAttributeNodeNS((Attr)node);
            object3.setTextContent(partsCategory.getLocalizedCategoryName());
            element2.appendChild((Node)object3);
            object = document.createElementNS(NS, "layers");
            for (Layer layer : partsCategory.getLayers()) {
                Element element6;
                Element element7 = document.createElementNS(NS, "layer");
                element7.setAttribute("id", layer.getId());
                Element element8 = document.createElementNS(NS, "display-name");
                Attr attr2 = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attr2.setValue(string);
                element8.setAttributeNodeNS(attr2);
                element8.setTextContent(layer.getLocalizedName());
                element7.appendChild(element8);
                Element element9 = document.createElementNS(NS, "order");
                element9.setTextContent(Integer.toString(layer.getOrder()));
                element7.appendChild(element9);
                ColorGroup colorGroup = layer.getColorGroup();
                if (colorGroup != null && colorGroup.isEnabled()) {
                    element6 = document.createElementNS(NS, "colorGroup");
                    element6.setAttribute("refid", colorGroup.getId());
                    element6.setAttribute("init-sync", layer.isInitSync() ? "true" : "false");
                    element7.appendChild(element6);
                }
                element6 = document.createElementNS(NS, "dir");
                element6.setTextContent(layer.getDir());
                element7.appendChild(element6);
                object.appendChild(element7);
            }
            element2.appendChild((Node)object);
            element5.appendChild(element2);
        }
        object7.appendChild(element5);
        Collection<ColorGroup> collection = characterData.getColorGroups();
        if (collection.size() > 0) {
            Element element10 = document.createElementNS(NS, "colorGroups");
            int n = 0;
            for (Object object3 : collection) {
                if (!((ColorGroup)object3).isEnabled()) continue;
                node = document.createElementNS(NS, "colorGroup");
                node.setAttribute("id", ((ColorGroup)object3).getId());
                object = document.createElementNS(NS, "display-name");
                Attr attr3 = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attr3.setValue(string);
                object.setAttributeNodeNS(attr3);
                object.setTextContent(((ColorGroup)object3).getLocalizedName());
                node.appendChild((Node)object);
                element10.appendChild(node);
                ++n;
            }
            if (n > 0) {
                object7.appendChild(element10);
            }
        }
        if (this.writePartsSetElements(document, element = document.createElementNS(NS, "presets"), characterData, true, false) > 0) {
            object7.appendChild(element);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        try {
            object2 = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("JAXP Configuration Failed.", transformerConfigurationException);
        }
        ((Transformer)object2).setOutputProperty("indent", "yes");
        ((Transformer)object2).setOutputProperty("encoding", "UTF-8");
        try {
            ((Transformer)object2).transform(new DOMSource(document), new StreamResult(new OutputStreamWriter(outputStream, Charset.forName("UTF-8"))));
        }
        catch (TransformerException transformerException) {
            object = new IOException("XML Convert failed.");
            ((Throwable)object).initCause(transformerException);
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFavorites(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData userData = this.getFavoritesUserData(characterData, "xml");
        OutputStream outputStream = userData.getOutputStream();
        try {
            this.saveFavorites(characterData, outputStream);
        }
        finally {
            outputStream.close();
        }
        UserData userData2 = this.getFavoritesUserData(characterData, "ser");
        Collection<PartsSet> collection = characterData.getPartsSets().values();
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>(collection);
        userData2.save(arrayList);
    }

    protected UserData getFavoritesUserData(CharacterData characterData, String string) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        String string2 = characterData.getId() + "-favorites." + string;
        URL uRL = characterData.getDocBase();
        UserData userData = userDataFactory.getMangledNamedUserData(uRL, string2);
        return userData;
    }

    protected void saveFavorites(CharacterData characterData, OutputStream outputStream) throws IOException {
        Transformer transformer;
        Document document;
        Object object;
        Object object2;
        if (characterData == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("JAXP Configuration Exception.", parserConfigurationException);
        }
        object2 = document.createElementNS(NS, "partssets");
        object2.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        object2.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        object2.setAttribute("xsi:schemaLocation", "http://com.exmaple/charactermanaj partsset.xsd");
        document.appendChild((Node)object2);
        this.writePartsSetElements(document, (Element)object2, characterData, false, true);
        object = TransformerFactory.newInstance();
        ((TransformerFactory)object).setAttribute("indent-number", 4);
        try {
            transformer = ((TransformerFactory)object).newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("JAXP Configuration Failed.", transformerConfigurationException);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        try {
            transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter(outputStream, Charset.forName("UTF-8"))));
        }
        catch (TransformerException transformerException) {
            IOException iOException = new IOException("XML Convert failed.");
            iOException.initCause(transformerException);
            throw iOException;
        }
    }

    protected int writePartsSetElements(Document document, Element element, CharacterData characterData, boolean bl, boolean bl2) {
        Map.Entry<String, PartsSet> entry;
        Map<String, PartsSet> map = characterData.getPartsSets();
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        HashMap<String, PartsSet> hashMap = new HashMap<String, PartsSet>();
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            PartsCategory partsCategory;
            entry = object.next();
            PartsSet partsSet = entry.getValue();
            if (partsSet.isPresetParts() && !bl || !partsSet.isPresetParts() && !bl2 || partsSet.isEmpty()) continue;
            String string2 = partsSet.getPartsSetId();
            String string3 = partsSet.getLocalizedName();
            Element element2 = document.createElementNS(NS, "preset");
            element2.setAttribute("id", string2);
            element.appendChild(element2);
            hashMap.put(partsSet.getPartsSetId(), partsSet);
            Element element3 = document.createElementNS(NS, "display-name");
            Attr attr = document.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            attr.setValue(string);
            element3.setAttributeNode(attr);
            element3.setTextContent(string3);
            element2.appendChild(element3);
            Color color = partsSet.getBgColor();
            if (color != null) {
                partsCategory = (PartsCategory)((Object)document.createElementNS(NS, "background-color"));
                partsCategory.setAttribute("color", "#" + Integer.toHexString(color.getRGB() & 0xFFFFFF));
                element2.appendChild((Node)((Object)partsCategory));
            }
            if ((partsCategory = partsSet.getAffineTransformParameter()) != null) {
                Element element4 = document.createElementNS(NS, "affine-transform-parameter");
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object2 : partsCategory) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(Double.toString((double)object2));
                }
                element4.setTextContent(stringBuilder.toString());
                element2.appendChild(element4);
            }
            for (Map.Entry entry2 : partsSet.entrySet()) {
                PartsCategory partsCategory2 = (PartsCategory)entry2.getKey();
                Element element4 = document.createElementNS(NS, "category");
                element4.setAttribute("refid", partsCategory2.getCategoryId());
                element2.appendChild(element4);
                List list = (List)entry2.getValue();
                for (PartsIdentifier partsIdentifier : list) {
                    String string4 = partsIdentifier.getPartsName();
                    Element element5 = document.createElementNS(NS, "parts");
                    element5.setAttribute("name", string4);
                    element4.appendChild(element5);
                    PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                    if (partsColorInfo == null) continue;
                    Element element6 = document.createElementNS(NS, "color");
                    element5.appendChild(element6);
                    for (Map.Entry<Layer, ColorInfo> entry3 : partsColorInfo.entrySet()) {
                        Object object3;
                        Layer layer = entry3.getKey();
                        ColorInfo colorInfo = entry3.getValue();
                        Element element7 = document.createElementNS(NS, "layer");
                        element7.setAttribute("refid", layer.getId());
                        element6.appendChild(element7);
                        ColorGroup colorGroup = colorInfo.getColorGroup();
                        boolean bl3 = colorInfo.isSyncColorGroup();
                        if (colorGroup.isEnabled()) {
                            object3 = document.createElementNS(NS, "color-group");
                            object3.setAttribute("group", colorGroup.getId());
                            object3.setAttribute("synchronized", bl3 ? "true" : "false");
                            element7.appendChild((Node)object3);
                        }
                        object3 = colorInfo.getColorParameter();
                        Element element8 = document.createElementNS(NS, "rgb");
                        Object[][] objectArrayArray = new Object[][]{{"red", ((ColorConvertParameter)object3).getOffsetR(), Float.valueOf(((ColorConvertParameter)object3).getFactorR()), Float.valueOf(((ColorConvertParameter)object3).getGammaR())}, {"green", ((ColorConvertParameter)object3).getOffsetG(), Float.valueOf(((ColorConvertParameter)object3).getFactorG()), Float.valueOf(((ColorConvertParameter)object3).getGammaG())}, {"blue", ((ColorConvertParameter)object3).getOffsetB(), Float.valueOf(((ColorConvertParameter)object3).getFactorB()), Float.valueOf(((ColorConvertParameter)object3).getGammaB())}, {"alpha", ((ColorConvertParameter)object3).getOffsetA(), Float.valueOf(((ColorConvertParameter)object3).getFactorA()), Float.valueOf(((ColorConvertParameter)object3).getGammaA())}};
                        for (Object[] objectArray : objectArrayArray) {
                            Element element9 = document.createElementNS(NS, objectArray[0].toString());
                            element9.setAttribute("offset", objectArray[1].toString());
                            element9.setAttribute("factor", objectArray[2].toString());
                            element9.setAttribute("gamma", objectArray[3].toString());
                            element8.appendChild(element9);
                        }
                        element7.appendChild(element8);
                        Element element10 = document.createElementNS(NS, "hsb");
                        element10.setAttribute("hue", Float.toString(((ColorConvertParameter)object3).getHue()));
                        element10.setAttribute("saturation", Float.toString(((ColorConvertParameter)object3).getSaturation()));
                        element10.setAttribute("brightness", Float.toString(((ColorConvertParameter)object3).getBrightness()));
                        element7.appendChild(element10);
                        Element element11 = document.createElementNS(NS, "rgb-replace");
                        ColorConv colorConv = ((ColorConvertParameter)object3).getColorReplace();
                        if (colorConv == null) {
                            colorConv = ColorConv.NONE;
                        }
                        element11.setAttribute("replace-type", colorConv.name());
                        element11.setAttribute("gray", Float.toString(((ColorConvertParameter)object3).getGrayLevel()));
                        element7.appendChild(element11);
                    }
                }
            }
        }
        if (bl && (object = characterData.getDefaultPartsSetId()) != null && ((String)object).length() > 0 && (entry = (PartsSet)hashMap.get(object)) != null && ((PartsSet)((Object)entry)).isPresetParts()) {
            element.setAttribute("default-preset", (String)object);
        }
        return hashMap.size();
    }

    protected void loadPartsSet(CharacterData characterData, Node node, boolean bl) throws XPathExpressionException {
        logger.log(Level.INFO, "loadPartsSet: " + characterData + " /presetParts=" + bl);
        XPath xPath = this.createXPath();
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        XPathExpression xPathExpression = xPath.compile("pre:preset");
        XPathExpression xPathExpression2 = xPath.compile("pre:display-name[lang('" + string + "')]");
        XPathExpression xPathExpression3 = xPath.compile("pre:display-name[position() = 1]");
        XPathExpression xPathExpression4 = xPath.compile("@id");
        XPathExpression xPathExpression5 = xPath.compile("@refid");
        XPathExpression xPathExpression6 = xPath.compile("@name");
        XPathExpression xPathExpression7 = xPath.compile("pre:category");
        XPathExpression xPathExpression8 = xPath.compile("pre:parts");
        XPathExpression xPathExpression9 = xPath.compile("pre:color/pre:layer");
        XPathExpression xPathExpression10 = xPath.compile("pre:color-group");
        XPathExpression xPathExpression11 = xPath.compile("pre:hsb");
        XPathExpression xPathExpression12 = xPath.compile("pre:rgb/pre:red|pre:rgb/pre:green|pre:rgb/pre:blue|pre:rgb/pre:alpha");
        XPathExpression xPathExpression13 = xPath.compile("pre:rgb-replace");
        XPathExpression xPathExpression14 = xPath.compile("pre:background-color/@color");
        XPathExpression xPathExpression15 = xPath.compile("pre:affine-transform-parameter");
        String string2 = null;
        Node node2 = (Node)xPath.evaluate("@default-preset", node, XPathConstants.NODE);
        if (node2 != null) {
            string2 = node2.getTextContent().trim();
        }
        for (Node node3 : this.iterable((NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET))) {
            Object object2;
            Iterator<Node> iterator;
            Object object3;
            Node node4;
            String string3 = ((Node)xPathExpression4.evaluate(node3, XPathConstants.NODE)).getTextContent().trim();
            if (string2 == null) {
                string2 = string3;
            }
            if ((node4 = (Node)xPathExpression2.evaluate(node3, XPathConstants.NODE)) == null) {
                node4 = (Node)xPathExpression3.evaluate(node3, XPathConstants.NODE);
            }
            String string4 = node4.getTextContent();
            PartsSet partsSet = new PartsSet();
            partsSet.setPartsSetId(string3);
            partsSet.setLocalizedName(string4);
            partsSet.setPresetParts(bl);
            Node node5 = (Node)xPathExpression14.evaluate(node3, XPathConstants.NODE);
            if (node5 != null) {
                object3 = node5.getTextContent().trim();
                try {
                    iterator = Color.decode((String)object3);
                    partsSet.setBgColor((Color)((Object)iterator));
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "bgColor parameter is invalid. :" + (String)object3, exception);
                }
            }
            if ((object3 = (Node)xPathExpression15.evaluate(node3, XPathConstants.NODE)) != null && (iterator = object3.getTextContent()) != null && ((String)((Object)iterator)).trim().length() > 0) {
                try {
                    object2 = new ArrayList();
                    for (String string5 : ((String)((Object)iterator)).split("\\s+")) {
                        ((ArrayList)object2).add(Double.valueOf(string5));
                    }
                    double[] dArray = new double[((ArrayList)object2).size()];
                    int n = 0;
                    Iterator<Object> iterator2 = ((ArrayList)object2).iterator();
                    while (iterator2.hasNext()) {
                        double d = (Double)iterator2.next();
                        dArray[n++] = d;
                    }
                    partsSet.setAffineTransformParameter(dArray);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "affine transform parameter is invalid. :" + iterator, exception);
                }
            }
            iterator = this.iterable((NodeList)xPathExpression7.evaluate(node3, XPathConstants.NODESET)).iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                String string6 = ((Node)xPathExpression5.evaluate(object2, XPathConstants.NODE)).getTextContent().trim();
                PartsCategory partsCategory = characterData.getPartsCategory(string6);
                if (partsCategory == null) {
                    logger.log(Level.WARNING, "undefined category: " + string6);
                    continue;
                }
                for (Node node6 : this.iterable((NodeList)xPathExpression8.evaluate(object2, XPathConstants.NODESET))) {
                    String string7 = ((Node)xPathExpression6.evaluate(node6, XPathConstants.NODE)).getTextContent().trim();
                    PartsIdentifier partsIdentifier = new PartsIdentifier(partsCategory, string7, string7);
                    AbstractMap abstractMap = null;
                    for (Node node7 : this.iterable((NodeList)xPathExpression9.evaluate(node6, XPathConstants.NODESET))) {
                        Node node82;
                        Serializable serializable;
                        String string8 = ((Node)xPathExpression5.evaluate(node7, XPathConstants.NODE)).getTextContent().trim();
                        Layer layer = partsCategory.getLayer(string8);
                        if (layer == null) {
                            logger.log(Level.WARNING, "undefined layer: " + string8);
                            continue;
                        }
                        if (abstractMap == null) {
                            abstractMap = new PartsColorInfo(partsCategory);
                        }
                        ColorInfo colorInfo = (ColorInfo)abstractMap.get(layer);
                        Element element = (Element)xPathExpression10.evaluate(node7, XPathConstants.NODE);
                        if (element != null) {
                            serializable = characterData.getColorGroup(element.getAttribute("group"));
                            boolean bl2 = Boolean.parseBoolean(element.getAttribute("synchronized"));
                            colorInfo.setColorGroup((ColorGroup)serializable);
                            colorInfo.setSyncColorGroup(bl2);
                        }
                        serializable = colorInfo.getColorParameter();
                        for (Node node82 : this.iterable((NodeList)xPathExpression12.evaluate(node7, XPathConstants.NODESET))) {
                            Element element2 = (Element)node82;
                            String string9 = element2.getNodeName();
                            int n = Integer.parseInt(element2.getAttribute("offset"));
                            float f = Float.parseFloat(element2.getAttribute("factor"));
                            float f2 = Float.parseFloat(element2.getAttribute("gamma"));
                            if ("red".equals(string9)) {
                                ((ColorConvertParameter)serializable).setOffsetR(n);
                                ((ColorConvertParameter)serializable).setFactorR(f);
                                ((ColorConvertParameter)serializable).setGammaR(f2);
                                continue;
                            }
                            if ("green".equals(string9)) {
                                ((ColorConvertParameter)serializable).setOffsetG(n);
                                ((ColorConvertParameter)serializable).setFactorG(f);
                                ((ColorConvertParameter)serializable).setGammaG(f2);
                                continue;
                            }
                            if ("blue".equals(string9)) {
                                ((ColorConvertParameter)serializable).setOffsetB(n);
                                ((ColorConvertParameter)serializable).setFactorB(f);
                                ((ColorConvertParameter)serializable).setGammaB(f2);
                                continue;
                            }
                            if (!"alpha".equals(string9)) continue;
                            ((ColorConvertParameter)serializable).setOffsetA(n);
                            ((ColorConvertParameter)serializable).setFactorA(f);
                            ((ColorConvertParameter)serializable).setGammaA(f2);
                        }
                        Element element3 = (Element)xPathExpression11.evaluate(node7, XPathConstants.NODE);
                        if (element3 != null) {
                            float f = Float.parseFloat(element3.getAttribute("hue"));
                            float f3 = Float.parseFloat(element3.getAttribute("saturation"));
                            float f4 = Float.parseFloat(element3.getAttribute("brightness"));
                            ((ColorConvertParameter)serializable).setHue(f);
                            ((ColorConvertParameter)serializable).setSaturation(f3);
                            ((ColorConvertParameter)serializable).setBrightness(f4);
                        }
                        if ((node82 = (Element)xPathExpression13.evaluate(node7, XPathConstants.NODE)) == null) continue;
                        Float f = Float.valueOf(Float.parseFloat(node82.getAttribute("gray")));
                        ColorConv colorConv = ColorConv.valueOf(node82.getAttribute("replace-type"));
                        ((ColorConvertParameter)serializable).setGrayLevel(f.floatValue());
                        ((ColorConvertParameter)serializable).setColorReplace(colorConv);
                    }
                    partsSet.appendParts(partsCategory, partsIdentifier, (PartsColorInfo)abstractMap);
                }
            }
            characterData.addPartsSet(partsSet);
        }
        if (bl) {
            characterData.setDefaultPartsSetId(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFavorites(CharacterData characterData) throws IOException {
        Object object;
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData userData = this.getFavoritesUserData(characterData, "ser");
        UserData userData2 = this.getFavoritesUserData(characterData, "xml");
        try {
            if (userData.exists() && userData.lastModified() >= userData2.lastModified()) {
                Collection collection = (Collection)userData.load();
                for (PartsSet partsSet : collection) {
                    characterData.addPartsSet(partsSet);
                }
                return;
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "cached favorites loading failed. :" + characterData, exception);
        }
        if (userData2.exists()) {
            object = userData2.openStream();
            try {
                this.loadPartsSet(characterData, (InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        try {
            object = characterData.getPartsSets().values();
            ArrayList arrayList = new ArrayList(object);
            userData.save(arrayList);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "cached favorites creation failed. :" + characterData, exception);
        }
    }

    protected void loadPartsSet(CharacterData characterData, InputStream inputStream) throws IOException {
        Document document;
        Object object;
        Object object2;
        if (characterData == null || inputStream == null) {
            throw new IllegalArgumentException();
        }
        Schema schema = this.loadSchema(PARTSSET_XML_SCHEMA);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setSchema(schema);
        try {
            object2 = documentBuilderFactory.newDocumentBuilder();
            object = new ArrayList();
            ((DocumentBuilder)object2).setErrorHandler(new ErrorHandler((ArrayList)object){
                final /* synthetic */ ArrayList val$errors;
                {
                    this.val$errors = arrayList;
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    this.val$errors.add(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    this.val$errors.add(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) throws SAXException {
                    this.val$errors.add(sAXParseException);
                }
            });
            document = ((DocumentBuilder)object2).parse(inputStream);
            if (((ArrayList)object).size() > 0) {
                throw (SAXParseException)((ArrayList)object).get(0);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("JAXP Configuration Failed.", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("PartsSet invalid format");
            iOException.initCause(sAXException);
            throw iOException;
        }
        try {
            object2 = this.createXPath();
            object = (Node)object2.evaluate("/pre:partssets", document, XPathConstants.NODE);
            if (object != null) {
                this.loadPartsSet(characterData, (Node)object, false);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            object = new IOException("PartsSet invalid format");
            ((Throwable)object).initCause((Throwable)object);
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CharacterData characterData, boolean bl) throws IOException {
        UserData[] userDataArray;
        Object object2;
        if (characterData == null || characterData.getDocBase() == null) {
            throw new IllegalArgumentException();
        }
        URL uRL = characterData.getDocBase();
        File file = new File(uRL.getPath());
        if (!file.exists() || !file.isFile()) {
            return;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
        try {
            object2 = randomAccessFile.getChannel();
            userDataArray = ((FileChannel)object2).tryLock();
            if (userDataArray == null) {
                throw new IOException("can not lock the configuration file. " + file);
            }
            userDataArray.release();
        }
        finally {
            randomAccessFile.close();
        }
        object2 = this.getCharacterDataCacheUserFile(uRL);
        if (object2.exists()) {
            object2.delete();
        }
        userDataArray = new UserData[]{!bl ? null : this.getFavoritesUserData(characterData, "xml"), this.getFavoritesUserData(characterData, "ser")};
        for (UserData object3 : userDataArray) {
            if (object3 == null || !object3.exists()) continue;
            object3.delete();
        }
        UserData userData = MainFrame.getWorkingSetUserData(characterData);
        if (userData != null && userData.exists()) {
            userData.delete();
        }
        String string = "." + System.currentTimeMillis() + ".deleted";
        File file2 = new File(file.getPath() + string);
        if (!file.renameTo(file2)) {
            throw new IOException("can not rename configuration file.:" + file);
        }
        File file3 = file.getParentFile();
        if (!bl) {
            File file4 = new File(file3.getPath() + string);
            file3.renameTo(file4);
        } else {
            this.removeRecursive(file3);
        }
    }

    protected void removeRecursive(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.removeRecursive(file2);
            }
        }
        file.delete();
    }

    protected Iterable<Node> iterable(final NodeList nodeList) {
        final int n = nodeList == null ? 0 : nodeList.getLength();
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < n;
                    }

                    @Override
                    public Node next() {
                        if (this.idx >= n) {
                            throw new NoSuchElementException();
                        }
                        return nodeList.item(this.idx++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected Schema loadSchema(String string) {
        Schema schema = this.schemaMap.get(string);
        if (schema != null) {
            return schema;
        }
        URL uRL = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(errorHandler);
            uRL = this.getSchemaURL(string);
            schema = schemaFactory.newSchema(uRL);
            this.schemaMap.put(string, schema);
            return schema;
        }
        catch (Exception exception) {
            throw new RuntimeException("schema creation failed. :" + uRL, exception);
        }
    }

    protected URL getSchemaURL(String string) {
        return this.getClass().getResource(string);
    }

    protected XPath createXPath() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String string) {
                if (string == null) {
                    throw new IllegalArgumentException();
                }
                if (string.equals("pre")) {
                    return CharacterDataPersistent.NS;
                }
                if (string.equals("xml")) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                return "";
            }

            public Iterator<?> getPrefixes(String string) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPrefix(String string) {
                throw new UnsupportedOperationException();
            }
        });
        return xPath;
    }

    public BufferedImage loadSamplePicture(CharacterData characterData, ImageLoader imageLoader) throws IOException {
        if (characterData == null || imageLoader == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.isValid()) {
            return null;
        }
        File file = this.getSamplePictureFile(characterData);
        if (file != null && file.exists()) {
            return imageLoader.load(new FileImageResource(file));
        }
        return null;
    }

    public boolean canSaveSamplePicture(CharacterData characterData) {
        if (characterData == null || !characterData.isValid()) {
            return false;
        }
        File file = this.getSamplePictureFile(characterData);
        if (file != null) {
            File file2;
            if (file.exists() && file.canWrite()) {
                return true;
            }
            if (!file.exists() && (file2 = file.getParentFile()) != null) {
                return file2.canWrite();
            }
        }
        return false;
    }

    protected File getSamplePictureFile(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URL uRL = characterData.getDocBase();
        if (uRL != null && uRL.getProtocol().equals("file")) {
            File file = new File(uRL.getPath());
            return new File(file.getParentFile(), SAMPLE_IMAGE_FILENAME);
        }
        return null;
    }

    public void saveSamplePicture(CharacterData characterData, BufferedImage bufferedImage) throws IOException {
        if (!this.canSaveSamplePicture(characterData)) {
            throw new IOException("can not write a sample picture.:" + characterData);
        }
        File file = this.getSamplePictureFile(characterData);
        if (bufferedImage != null) {
            AppConfig appConfig = AppConfig.getInstance();
            Color color = appConfig.getSampleImageBgColor();
            ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
            imageSaveHelper.savePicture(bufferedImage, color, file, null);
        } else if (file.exists() && !file.delete()) {
            throw new IOException("sample pucture delete failed. :" + file);
        }
    }

    public static interface ProfileListErrorHandler {
        public void occureException(File var1, Throwable var2);
    }
}

