/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.CharacterDataWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharacterDataFileWriter
implements CharacterDataWriter {
    protected File outFile;
    protected File tmpFile;
    protected Exception occureException;

    protected AbstractCharacterDataFileWriter(File file) throws IOException {
        File file2;
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("not writable: " + file);
        }
        this.tmpFile = file2 = new File(file.getPath() + ".tmp");
        this.outFile = file;
    }

    @Override
    public void writeExportProp(Properties properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteExportProp(properties);
        }
        catch (IOException iOException) {
            this.occureException = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            this.occureException = exception;
            IOException iOException = new IOException("write characterdata failed.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected abstract void internalWriteExportProp(Properties var1) throws IOException;

    @Override
    public void writeCharacterData(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteCharacterData(characterData);
        }
        catch (IOException iOException) {
            this.occureException = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            this.occureException = exception;
            IOException iOException = new IOException("write characterdata failed.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected abstract void internalWriteCharacterData(CharacterData var1) throws IOException;

    @Override
    public void writeTextUTF16LE(String string, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteTextUTF16LE(string, string2);
        }
        catch (IOException iOException) {
            this.occureException = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            this.occureException = exception;
            IOException iOException = new IOException("internalWriteTextUTF16 failed.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected abstract void internalWriteTextUTF16LE(String var1, String var2) throws IOException;

    @Override
    public void writeSamplePicture(BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteSamplePicture(bufferedImage);
        }
        catch (IOException iOException) {
            this.occureException = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            this.occureException = exception;
            IOException iOException = new IOException("write sample picture failed.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected abstract void internalWriteSamplePicture(BufferedImage var1) throws IOException;

    @Override
    public void writePartsImages(Map<PartsIdentifier, PartsSpec> map) throws IOException {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWritePartsImages(map);
        }
        catch (IOException iOException) {
            this.occureException = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            this.occureException = exception;
            IOException iOException = new IOException("write parts images failed.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected abstract void internalWritePartsImages(Map<PartsIdentifier, PartsSpec> var1) throws IOException;

    @Override
    public void close() throws IOException {
        block4: {
            try {
                this.internalClose();
                this.outFile.delete();
            }
            catch (Exception exception) {
                if (this.occureException != null) break block4;
                this.occureException = exception;
            }
        }
        if (this.occureException != null) {
            this.tmpFile.delete();
            return;
        }
        if (!this.tmpFile.renameTo(this.outFile)) {
            throw new IOException("rename failed. " + this.tmpFile);
        }
    }

    protected abstract void internalClose() throws IOException;
}

