/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsCategoryResolver;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import java.awt.Color;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsSet
extends AbstractMap<PartsCategory, List<PartsIdentifier>>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5972528889825451761L;
    private String partsSetId;
    private String localizedName;
    private boolean presetParts;
    private Color bgColor;
    private double[] affineTransformParameter;
    private HashMap<PartsCategory, List<PartsIdentifier>> parts = new HashMap();
    private HashMap<PartsIdentifier, PartsColorInfo> partsColorInfoMap = new HashMap();

    public PartsSet() {
        this(null, null, false);
    }

    public PartsSet(String string, String string2, boolean bl) {
        this.partsSetId = string;
        this.localizedName = string2;
        this.presetParts = bl;
    }

    protected PartsSet(PartsSet partsSet, PartsCategoryResolver partsCategoryResolver) {
        Serializable serializable;
        Serializable serializable2;
        Comparable<PartsIdentifier> comparable;
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        this.partsSetId = partsSet.partsSetId;
        this.localizedName = partsSet.localizedName;
        this.presetParts = partsSet.presetParts;
        this.bgColor = partsSet.bgColor;
        this.affineTransformParameter = partsSet.affineTransformParameter == null ? null : (double[])partsSet.affineTransformParameter.clone();
        for (Map.Entry<PartsIdentifier, PartsColorInfo> entry : partsSet.partsColorInfoMap.entrySet()) {
            comparable = entry.getKey();
            if (partsCategoryResolver != null) {
                serializable2 = ((PartsIdentifier)comparable).getPartsCategory();
                serializable = partsCategoryResolver.getPartsCategory(serializable2.getCategoryId());
                if (serializable == null) continue;
                if (serializable2 != serializable) {
                    comparable = new PartsIdentifier((PartsCategory)serializable, ((PartsIdentifier)comparable).getPartsName(), ((PartsIdentifier)comparable).getLocalizedPartsName());
                }
            }
            serializable2 = entry.getValue().clone();
            this.partsColorInfoMap.put((PartsIdentifier)comparable, (PartsColorInfo)serializable2);
        }
        for (Map.Entry<Comparable<PartsIdentifier>, Object> entry : partsSet.parts.entrySet()) {
            comparable = (PartsCategory)entry.getKey();
            serializable2 = comparable;
            if (partsCategoryResolver != null) {
                serializable = partsCategoryResolver.getPartsCategory(((PartsCategory)comparable).getCategoryId());
                if (serializable == null) continue;
                if (serializable != comparable) {
                    serializable2 = serializable;
                }
            }
            serializable = new ArrayList((Collection)entry.getValue());
            this.parts.put((PartsCategory)serializable2, (List<PartsIdentifier>)((Object)serializable));
        }
    }

    public PartsSet createCompatible(PartsCategoryResolver partsCategoryResolver) {
        if (partsCategoryResolver == null) {
            throw new IllegalArgumentException();
        }
        return new PartsSet(this, partsCategoryResolver);
    }

    @Override
    public PartsSet clone() {
        return new PartsSet(this, null);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.partsSetId == null ? 0 : this.partsSetId.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof PartsSet) {
            PartsSet partsSet = (PartsSet)object;
            if ((this.partsSetId == partsSet.partsSetId || this.partsSetId != null && this.partsSetId.equals(partsSet.partsSetId)) && super.equals(partsSet) && this.partsColorInfoMap.equals(partsSet.partsColorInfoMap) && (this.bgColor == partsSet.bgColor || this.bgColor != null && this.bgColor.equals(partsSet.bgColor)) && (this.affineTransformParameter == partsSet.affineTransformParameter || this.affineTransformParameter != null && Arrays.equals(this.affineTransformParameter, partsSet.affineTransformParameter))) {
                return true;
            }
        }
        return false;
    }

    public void setPresetParts(boolean bl) {
        this.presetParts = bl;
    }

    public boolean isPresetParts() {
        return this.presetParts;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setAffineTransformParameter(double[] dArray) {
        if (dArray != null && dArray.length != 4 && dArray.length != 6) {
            throw new IllegalArgumentException("affineTransformParameter invalid length.");
        }
        this.affineTransformParameter = dArray == null ? null : (double[])dArray.clone();
    }

    public double[] getAffineTransformParameter() {
        return this.affineTransformParameter == null ? null : (double[])this.affineTransformParameter.clone();
    }

    public void setPartsSetId(String string) {
        this.partsSetId = string;
    }

    public void setLocalizedName(String string) {
        this.localizedName = string;
    }

    public String getPartsSetId() {
        return this.partsSetId;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public Set<Map.Entry<PartsCategory, List<PartsIdentifier>>> entrySet() {
        return this.parts.entrySet();
    }

    public PartsColorInfo getColorInfo(PartsIdentifier partsIdentifier) {
        PartsColorInfo partsColorInfo = this.partsColorInfoMap.get(partsIdentifier);
        return partsColorInfo == null ? null : partsColorInfo.clone();
    }

    public void appendParts(PartsCategory partsCategory, PartsIdentifier partsIdentifier, PartsColorInfo partsColorInfo) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        List<PartsIdentifier> list = this.parts.get(partsCategory);
        if (list == null) {
            list = new ArrayList<PartsIdentifier>();
            this.parts.put(partsCategory, list);
        }
        if (partsIdentifier != null) {
            list.add(partsIdentifier);
            if (partsColorInfo != null) {
                this.partsColorInfoMap.put(partsIdentifier, partsColorInfo.clone());
            }
        }
    }

    public void removeColorInfo() {
        this.partsColorInfoMap.clear();
    }

    @Override
    public String toString() {
        return this.getLocalizedName();
    }
}

