/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsFiles
extends AbstractMap<Layer, ImageResource>
implements Serializable {
    private static final long serialVersionUID = 5799830380308843243L;
    private HashMap<Layer, ImageResource> partsMap = new HashMap();
    private final PartsIdentifier partsIdentifier;

    public PartsFiles(PartsIdentifier partsIdentifier) {
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.partsIdentifier = partsIdentifier;
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    @Override
    public Set<Map.Entry<Layer, ImageResource>> entrySet() {
        return Collections.unmodifiableSet(this.partsMap.entrySet());
    }

    @Override
    public ImageResource put(Layer layer, ImageResource imageResource) {
        if (layer == null || imageResource == null) {
            throw new IllegalArgumentException();
        }
        if (!this.partsIdentifier.hasLayer(layer)) {
            throw new IllegalArgumentException(layer.toString());
        }
        return this.partsMap.put(layer, imageResource);
    }

    @Override
    public ImageResource get(Object object) {
        return this.partsMap.get(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.partsMap.containsKey(object);
    }

    public long lastModified() {
        long l = 0L;
        for (ImageResource imageResource : this.values()) {
            long l2 = imageResource.lastModified();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }
}

