/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsColorManager {
    private static final long serialVersionUID = 3246538139597289650L;
    private HashMap<PartsCategory, PartsColorInfo> categoryColorInfoMap = new HashMap();
    private HashMap<PartsIdentifier, PartsColorInfo> partsColorInfoMap = new HashMap();
    private HashMap<ColorGroup, ColorConvertParameter> recentColorGroupMap = new HashMap();
    private PartsSpecResolver partsSpecResolver;

    public PartsColorManager(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsSpecResolver = partsSpecResolver;
    }

    public PartsColorInfo getPartsColorInfo(PartsIdentifier partsIdentifier, boolean bl) {
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        PartsColorInfo partsColorInfo = this.partsColorInfoMap.get(partsIdentifier);
        if (partsColorInfo == null) {
            partsColorInfo = this.createDefaultColorInfo(partsIdentifier);
            if (bl) {
                this.partsColorInfoMap.put(partsIdentifier, partsColorInfo);
            }
        }
        return partsColorInfo;
    }

    public void setPartsColorInfo(PartsIdentifier partsIdentifier, PartsColorInfo partsColorInfo, boolean bl) {
        if (partsIdentifier == null || partsColorInfo == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            PartsCategory partsCategory = partsIdentifier.getPartsCategory();
            this.resetPartsColorInfo(partsCategory);
            this.categoryColorInfoMap.put(partsCategory, partsColorInfo);
        } else {
            this.partsColorInfoMap.put(partsIdentifier, partsColorInfo);
        }
        this.setRecentColorGroup(partsColorInfo);
        this.categoryColorInfoMap.put(partsIdentifier.getPartsCategory(), partsColorInfo);
    }

    protected void setRecentColorGroup(PartsColorInfo partsColorInfo) {
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            ColorInfo colorInfo = entry.getValue();
            ColorGroup colorGroup = colorInfo.getColorGroup();
            if (!colorInfo.isSyncColorGroup() || colorGroup == null || !colorGroup.isEnabled()) continue;
            this.recentColorGroupMap.put(colorGroup, colorInfo.getColorParameter());
        }
    }

    protected ColorConvertParameter getRecentColorGroup(ColorGroup colorGroup) {
        if (colorGroup == null || !colorGroup.isEnabled()) {
            return null;
        }
        return this.recentColorGroupMap.get(colorGroup);
    }

    public PartsColorInfo getPartsColorInfo(PartsCategory partsCategory) {
        return this.categoryColorInfoMap.get(partsCategory);
    }

    public void resetPartsColorInfo() {
        this.resetPartsColorInfo(null);
    }

    public void resetPartsColorInfo(PartsCategory partsCategory) {
        if (partsCategory == null) {
            this.partsColorInfoMap.clear();
            return;
        }
        Iterator<Map.Entry<PartsIdentifier, PartsColorInfo>> iterator = this.partsColorInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PartsIdentifier, PartsColorInfo> entry = iterator.next();
            PartsIdentifier partsIdentifier = entry.getKey();
            if (!partsIdentifier.getPartsCategory().equals(partsCategory)) continue;
            iterator.remove();
        }
    }

    protected PartsColorInfo createDefaultColorInfo(PartsIdentifier partsIdentifier) {
        Cloneable cloneable;
        Serializable serializable;
        Object object;
        PartsColorInfo partsColorInfo = new PartsColorInfo(partsIdentifier.getPartsCategory());
        PartsSpec partsSpec = this.partsSpecResolver.getPartsSpec(partsIdentifier);
        if (partsSpec != null) {
            object = partsSpec.getColorGroup();
            if (object != null && ((ColorGroup)object).isEnabled()) {
                for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
                    serializable = entry.getValue();
                    ((ColorInfo)serializable).setColorGroup((ColorGroup)object);
                    ((ColorInfo)serializable).setSyncColorGroup(true);
                }
            }
        } else {
            object = this.categoryColorInfoMap.get(partsIdentifier.getPartsCategory());
            if (object != null) {
                for (Map.Entry<Layer, ColorInfo> entry : ((PartsColorInfo)object).entrySet()) {
                    serializable = entry.getKey();
                    cloneable = entry.getValue();
                    if (!partsColorInfo.containsKey(serializable)) continue;
                    partsColorInfo.put((Layer)serializable, (ColorInfo)cloneable);
                }
            }
        }
        for (Map.Entry entry : partsColorInfo.entrySet()) {
            ColorInfo colorInfo = (ColorInfo)entry.getValue();
            serializable = colorInfo.getColorGroup();
            if (serializable == null || !((ColorGroup)serializable).isEnabled() || !colorInfo.isSyncColorGroup() || (cloneable = this.getRecentColorGroup((ColorGroup)serializable)) == null) continue;
            colorInfo.setColorParameter((ColorConvertParameter)cloneable);
        }
        return partsColorInfo;
    }

    public Map<PartsIdentifier, PartsColorInfo> getPartsColorInfoMap() {
        return this.partsColorInfoMap;
    }
}

