/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsColorInfo
extends AbstractMap<Layer, ColorInfo>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8639109147043912257L;
    private HashMap<Layer, ColorInfo> colorInfoMap = new HashMap();
    private final PartsCategory partsCategory;

    public PartsColorInfo(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.partsCategory = partsCategory;
        this.init();
    }

    protected PartsColorInfo(PartsColorInfo partsColorInfo) {
        if (partsColorInfo == null) {
            throw new IllegalArgumentException();
        }
        this.partsCategory = partsColorInfo.partsCategory;
        this.init();
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.colorInfoMap.entrySet()) {
            Layer layer = entry.getKey();
            ColorInfo colorInfo = entry.getValue();
            this.colorInfoMap.put(layer, colorInfo.clone());
        }
    }

    @Override
    public PartsColorInfo clone() {
        return new PartsColorInfo(this);
    }

    private void init() {
        for (Layer layer : this.partsCategory.getLayers()) {
            this.colorInfoMap.put(layer, this.createColorInfo(layer));
        }
    }

    protected ColorInfo createColorInfo(Layer layer) {
        ColorInfo colorInfo = new ColorInfo();
        colorInfo.setColorGroup(layer.getColorGroup());
        colorInfo.setSyncColorGroup(layer.getColorGroup().isEnabled());
        colorInfo.setColorParameter(new ColorConvertParameter());
        return colorInfo;
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    @Override
    public Set<Map.Entry<Layer, ColorInfo>> entrySet() {
        return this.colorInfoMap.entrySet();
    }

    @Override
    public ColorInfo put(Layer layer, ColorInfo colorInfo) {
        if (layer == null || colorInfo == null) {
            throw new IllegalArgumentException();
        }
        if (!this.colorInfoMap.containsKey(layer)) {
            throw new IllegalArgumentException("invalid layer: " + layer);
        }
        return this.colorInfoMap.put(layer, colorInfo);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append("(");
        stringBuilder.append(this.colorInfoMap.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

