/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.BeanPropertiesUtilities;
import charactermanaj.util.ConfigurationDirUtilities;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppConfig {
    private static final String CONFIG_NAME = "appConfig.xml";
    public static final String APP_VERSION = "1.0";
    public static final String COMMON_CHARACTER_DIR_PROPERTY_NAME = "character.dir";
    private static final Logger logger = ApplicationLogger.getLogger();
    private static final AppConfig singleton = new AppConfig();
    private String commonCharacterDataDir = "";
    private String defaultProfileId = "default";
    private Color sampleImageBgColor = Color.white;
    private Color defaultImageBgColor = Color.white;
    private Color checkedItemBgColor = Color.cyan.brighter();
    private Color selectedItemBgColor = Color.orange;
    private Color invalidBgColor = Color.red.brighter().brighter();
    private float compressionQuality = 0.8f;
    private Color exportPresetWarningsForegroundColor = Color.red;
    private int jarTransferBufferSize = 4096;
    private String zipNameEncoding = "MS932";
    private Color disabledCellForegroundColor = Color.gray;
    private int dirWatchInterval = 7000;
    private boolean enableDirWatch = true;
    private int fileTransferBufferSize = 4096;
    private long previewIndeicatorDelay = 300L;
    private boolean informationDialogOpenMethod = true;
    private boolean noRemoveLog = false;
    private Color gridColor = Color.gray;

    public static AppConfig getInstance() {
        return singleton;
    }

    private AppConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        Properties properties = new Properties();
        try {
            URL[] uRLArray;
            File file = ConfigurationDirUtilities.getApplicationBaseDir();
            File file2 = ConfigurationDirUtilities.getUserDataDir();
            for (URL uRL : uRLArray = new URL[]{this.getClass().getResource("/appConfig.xml"), new File(file, CONFIG_NAME).getCanonicalFile().toURL(), new File(file2, CONFIG_NAME).toURL()}) {
                try {
                    InputStream inputStream = uRL.openStream();
                    if (inputStream == null) continue;
                    try {
                        properties.loadFromXML(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "appConfig.xml loading failed.: " + uRL, exception);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("appConfig.xml loading failed.", exception);
        }
        BeanPropertiesUtilities.loadFromProperties(this, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws IOException {
        Properties properties = this.getProperties();
        File file = ConfigurationDirUtilities.getUserDataDir();
        File file2 = new File(file, CONFIG_NAME);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            properties.storeToXML((OutputStream)bufferedOutputStream, CONFIG_NAME, "UTF-8");
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public static Set<String> checkProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        AppConfig appConfig = new AppConfig();
        return BeanPropertiesUtilities.loadFromProperties(appConfig, properties);
    }

    public Set<String> update(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        return BeanPropertiesUtilities.loadFromProperties(this, properties);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        BeanPropertiesUtilities.saveToProperties(this, properties);
        return properties;
    }

    public File getSystemCharactersDir() {
        File file = ConfigurationDirUtilities.getApplicationBaseDir();
        File[] fileArray = new File[]{this.getAbsoluteFile(file, this.getCommonCharacterDataDir()), this.getAbsoluteFile(file, System.getProperty(COMMON_CHARACTER_DIR_PROPERTY_NAME)), this.getAbsoluteFile(file, "characters")};
        File file2 = null;
        for (File file3 : fileArray) {
            if (file3 == null || !file3.exists() || !file3.isDirectory()) continue;
            file2 = file3;
            break;
        }
        return file2;
    }

    protected File getAbsoluteFile(File file, String string) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            try {
                file2 = new File(file, string.trim()).getCanonicalFile();
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "invalid dir: base=" + file + "/file=" + string, iOException);
                return null;
            }
        }
        return file2;
    }

    public File getUserCharactersDir() {
        File file = new File(ConfigurationDirUtilities.getUserDataDir(), "characters");
        file.mkdirs();
        return file;
    }

    public String getCommonCharacterDataDir() {
        return this.commonCharacterDataDir;
    }

    public void setCommonCharacterDataDir(String string) {
        if (string == null) {
            string = "";
        }
        this.commonCharacterDataDir = string;
    }

    public String getDefaultProfileId() {
        return this.defaultProfileId;
    }

    public void setDefaultProfileId(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.defaultProfileId = string.trim();
    }

    public Color getSampleImageBgColor() {
        return this.sampleImageBgColor;
    }

    public void setSampleImageBgColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.sampleImageBgColor = color;
    }

    public Color getDefaultImageBgColor() {
        return this.defaultImageBgColor;
    }

    public void setDefaultImageBgColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.defaultImageBgColor = color;
    }

    public Color getCheckedItemBgColor() {
        return this.checkedItemBgColor;
    }

    public void setCheckedItemBgColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.checkedItemBgColor = color;
    }

    public Color getSelectedItemBgColor() {
        return this.selectedItemBgColor;
    }

    public void setSelectedItemBgColor(Color color) {
        this.selectedItemBgColor = color;
    }

    public Color getInvalidBgColor() {
        return this.invalidBgColor;
    }

    public void setInvalidBgColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.invalidBgColor = color;
    }

    public float getCompressionQuality() {
        return this.compressionQuality;
    }

    public void setCompressionQuality(float f) {
        if (f < 0.1f || f > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.compressionQuality = f;
    }

    public Color getExportPresetWarningsForegroundColor() {
        return this.exportPresetWarningsForegroundColor;
    }

    public void setExportPresetWarningsForegroundColor(Color color) {
        this.exportPresetWarningsForegroundColor = color;
    }

    public int getJarTransferBufferSize() {
        return this.jarTransferBufferSize;
    }

    public void setJarTransferBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.jarTransferBufferSize = n;
    }

    public String getZipNameEncoding() {
        return this.zipNameEncoding;
    }

    public void setZipNameEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            Charset.forName(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("unsupported charset: " + string);
        }
        this.zipNameEncoding = string;
    }

    public Color getDisabledCellForgroundColor() {
        return this.disabledCellForegroundColor;
    }

    public void setDisabledCellForegroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.disabledCellForegroundColor = color;
    }

    public int getDirWatchInterval() {
        return this.dirWatchInterval;
    }

    public void setDirWatchInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.dirWatchInterval = n;
    }

    public boolean isEnableDirWatch() {
        return this.enableDirWatch;
    }

    public void setEnableDirWatch(boolean bl) {
        this.enableDirWatch = bl;
    }

    public int getFileTransferBufferSize() {
        return this.fileTransferBufferSize;
    }

    public void setFileTransferBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.fileTransferBufferSize = n;
    }

    public long getPreviewIndicatorDelay() {
        return this.previewIndeicatorDelay;
    }

    public void setPreviewIndeicatorDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.previewIndeicatorDelay = l;
    }

    public boolean isInformationDialogOpenMethod() {
        return this.informationDialogOpenMethod;
    }

    public void setInformationDialogOpenMethod(boolean bl) {
        this.informationDialogOpenMethod = bl;
    }

    public boolean isNoRemoveLog() {
        return this.noRemoveLog;
    }

    public void setNoRemoveLog(boolean bl) {
        this.noRemoveLog = bl;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.gridColor = color;
    }
}

