/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

public class GammaTableFactory {
    private float[] gammas;

    public GammaTableFactory(float f) {
        this.setGamma(f);
    }

    public GammaTableFactory(float[] fArray) {
        this.setGamma(fArray);
    }

    public final void setGamma(float f) {
        this.setGamma(new float[]{f, f, f, f});
    }

    public final void setGamma(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException();
        }
        this.gammas = fArray;
    }

    public int[][] createGammaTable() {
        int n = this.gammas.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < 4; ++i) {
            float f = i < n ? this.gammas[i] : 1.0f;
            nArrayArray[i] = this.createGamma(f);
        }
        return nArrayArray;
    }

    private int[] createGamma(float f) {
        if (f < 0.01f) {
            f = 0.01f;
        }
        int[] nArray = new int[256];
        for (int i = 0; i <= 255; ++i) {
            nArray[i] = (int)(Math.pow((double)i / 255.0, 1.0f / f) * 255.0) & 0xFF;
        }
        return nArray;
    }
}

