/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.filters.AbstractFilter;
import charactermanaj.graphics.filters.GammaTableFactory;
import java.awt.Color;

public class ColorConvertFilter
extends AbstractFilter {
    private final ColorReplace colorReplace;
    private final float[] hsbOffsets;
    private final float grayLevel;
    private final int[][] gammaTbl;

    public ColorConvertFilter(ColorReplace colorReplace, float[] object, float f, GammaTableFactory gammaTableFactory) {
        if (gammaTableFactory == null) {
            gammaTableFactory = new GammaTableFactory(1.0f);
        }
        if (object != null && ((float[])object).length < 3) {
            throw new IllegalArgumentException("hsbOffset too short.");
        }
        if (object != null) {
            object = object[0] == 0.0f && object[1] == 0.0f && object[2] == 0.0f ? null : (float[])object.clone();
        }
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.grayLevel = f;
        this.gammaTbl = gammaTableFactory.createGammaTable();
        this.hsbOffsets = object;
        this.colorReplace = colorReplace;
    }

    protected void filter(int[] nArray) {
        float f = this.grayLevel;
        float f2 = 1.0f - f;
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray2[i] = (int)((float)i * f) & 0xFF;
            nArray3[i] = (int)((float)i * f2) & 0xFF;
        }
        ColorReplace colorReplace = this.colorReplace;
        int[] nArray4 = new int[3];
        float[] fArray = this.hsbOffsets;
        float[] fArray2 = new float[3];
        int[][] nArray5 = this.gammaTbl;
        for (int n : nArray) {
            int n2 = nArray5[0][n >> 24 & 0xFF];
            int n3 = nArray5[1][n >> 16 & 0xFF];
            int n4 = nArray5[2][n >> 8 & 0xFF];
            int n5 = nArray5[3][n & 0xFF];
            if (colorReplace != null) {
                nArray4[0] = n3;
                nArray4[1] = n4;
                nArray4[2] = n5;
                colorReplace.convert(nArray4);
                n3 = nArray4[0];
                n4 = nArray4[1];
                n5 = nArray4[2];
            }
            int n6 = 77 * n3 + 150 * n4 + 29 * n5 >> 8 & 0xFF;
            n3 = nArray2[n3] + nArray3[n6] & 0xFF;
            n4 = nArray2[n4] + nArray3[n6] & 0xFF;
            n5 = nArray2[n5] + nArray3[n6] & 0xFF;
            if (fArray != null) {
                int n7;
                Color.RGBtoHSB(n3, n4, n5, fArray2);
                for (n7 = 0; n7 < 3; ++n7) {
                    int n8 = n7;
                    fArray2[n8] = fArray2[n8] + fArray[n7];
                }
                for (n7 = 1; n7 < 3; ++n7) {
                    if (fArray2[n7] < 0.0f) {
                        fArray2[n7] = 0.0f;
                        continue;
                    }
                    if (!(fArray2[n7] > 1.0f)) continue;
                    fArray2[n7] = 1.0f;
                }
                n7 = Color.HSBtoRGB(fArray2[0], fArray2[1], fArray2[2]);
                n = n2 << 24 | n7 & 0xFFFFFF;
            } else {
                n = n2 << 24 | n3 << 16 | n4 << 8 | n5;
            }
            nArray[var12_13] = n;
        }
    }

    public static interface ColorReplace {
        public void convert(int[] var1);
    }
}

