/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImageBuildPartsInfo
implements Comparable<ImageBuildPartsInfo> {
    private int order;
    private Layer layer;
    private ImageResource imageResource;
    private ColorConvertParameter colorParam;

    public ImageBuildPartsInfo(int n, Layer layer, ImageResource imageResource, ColorConvertParameter colorConvertParameter) {
        this.order = n;
        this.layer = layer;
        this.imageResource = imageResource;
        this.colorParam = colorConvertParameter;
    }

    public int hashCode() {
        return this.order ^ this.layer.hashCode() ^ ((Object)this.imageResource).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ImageBuildPartsInfo) {
            ImageBuildPartsInfo imageBuildPartsInfo = (ImageBuildPartsInfo)object;
            return this.order == imageBuildPartsInfo.order && this.layer.equals(imageBuildPartsInfo.layer) && ((Object)this.imageResource).equals(imageBuildPartsInfo.imageResource) && this.colorParam.equals(imageBuildPartsInfo.colorParam);
        }
        return false;
    }

    @Override
    public int compareTo(ImageBuildPartsInfo imageBuildPartsInfo) {
        int n = this.layer.compareTo(imageBuildPartsInfo.layer);
        if (n == 0) {
            n = this.order - imageBuildPartsInfo.order;
        }
        if (n == 0) {
            n = this.imageResource.compareTo(imageBuildPartsInfo.imageResource);
        }
        return n;
    }

    public int getOrder() {
        return this.order;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public ColorConvertParameter getColorParam() {
        return this.colorParam;
    }

    public ImageResource getFile() {
        return this.imageResource;
    }
}

