/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageCache;
import charactermanaj.graphics.filters.ColorConvertFilter;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.filters.GammaTableFactory;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.graphics.io.ImageResource;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ColorConvertedImageCachedLoader {
    public static final int MAX_CACHE = 20;
    public static final long DEFAULT_SWEEP_THRESHOLD = 60000L;
    private int cacheSize;
    private LinkedList<ColorConvertedImageCache> caches = new LinkedList();
    private ImageCachedLoader loader;

    public ColorConvertedImageCachedLoader() {
        this(20, 60000L);
    }

    public ColorConvertedImageCachedLoader(int n, long l) {
        if (n < 1) {
            n = 1;
        }
        this.cacheSize = n;
        this.loader = new ImageCachedLoader(n, l);
    }

    public BufferedImage load(ImageResource imageResource, ColorConvertParameter colorConvertParameter) throws IOException {
        Object object;
        if (imageResource == null) {
            throw new IllegalArgumentException();
        }
        if (colorConvertParameter == null) {
            colorConvertParameter = new ColorConvertParameter();
        }
        long l = imageResource.lastModified();
        Iterator iterator = this.caches.iterator();
        while (iterator.hasNext()) {
            object = (ColorConvertedImageCache)iterator.next();
            if (!((Object)imageResource).equals(((ColorConvertedImageCache)object).getImageResource())) continue;
            iterator.remove();
            if (((ColorConvertedImageCache)object).getLastModified() != l || !((ColorConvertedImageCache)object).getColorConvParam().equals(colorConvertParameter)) break;
            this.caches.addFirst((ColorConvertedImageCache)object);
            this.loader.sweep();
            return ((ColorConvertedImageCache)object).getImage();
        }
        colorConvertParameter = colorConvertParameter.clone();
        object = this.loader.load(imageResource);
        object = this.colorConvert((BufferedImage)object, colorConvertParameter);
        ColorConvertedImageCache colorConvertedImageCache = new ColorConvertedImageCache();
        colorConvertedImageCache.setImageResource(imageResource);
        colorConvertedImageCache.setLastModified(l);
        colorConvertedImageCache.setImage((BufferedImage)object);
        colorConvertedImageCache.setColorConvParam(colorConvertParameter);
        this.caches.addFirst(colorConvertedImageCache);
        while (this.caches.size() > this.cacheSize) {
            this.caches.removeLast();
        }
        return object;
    }

    protected BufferedImage colorConvert(BufferedImage bufferedImage, ColorConvertParameter colorConvertParameter) {
        float[] fArray = new float[]{colorConvertParameter.getFactorR(), colorConvertParameter.getFactorG(), colorConvertParameter.getFactorB(), colorConvertParameter.getFactorA()};
        float[] fArray2 = new float[]{colorConvertParameter.getOffsetR(), colorConvertParameter.getOffsetG(), colorConvertParameter.getOffsetB(), colorConvertParameter.getOffsetA()};
        RescaleOp rescaleOp = new RescaleOp(fArray, fArray2, null);
        float[] fArray3 = new float[]{colorConvertParameter.getGammaA(), colorConvertParameter.getGammaR(), colorConvertParameter.getGammaG(), colorConvertParameter.getGammaB()};
        float[] fArray4 = new float[]{colorConvertParameter.getHue(), colorConvertParameter.getSaturation(), colorConvertParameter.getBrightness()};
        ColorConvertFilter colorConvertFilter = new ColorConvertFilter(colorConvertParameter.getColorReplace(), fArray4, colorConvertParameter.getGrayLevel(), new GammaTableFactory(fArray3));
        bufferedImage = colorConvertFilter.filter(bufferedImage, null);
        bufferedImage = rescaleOp.filter(bufferedImage, bufferedImage);
        return bufferedImage;
    }
}

