/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.stage.WindowEvent;

public class ContextMenuUtil {
    private static Map<ObservableList<Menu>, ListChangeListener<Menu>> menuListChangeListeners = new WeakHashMap<ObservableList<Menu>, ListChangeListener<Menu>>();
    private static Map<ObservableList<MenuItem>, ListChangeListener<MenuItem>> menuItemListChangeListeners = new WeakHashMap<ObservableList<MenuItem>, ListChangeListener<MenuItem>>();
    private static Map<ReadOnlyObjectProperty<ContextMenu>, ChangeListener<ContextMenu>> parentPopupChangeListeners = new WeakHashMap<ReadOnlyObjectProperty<ContextMenu>, ChangeListener<ContextMenu>>();
    private static Map<ContextMenu, EventHandler<WindowEvent>> contextMenuWindowShowingEventHandlers = new WeakHashMap<ContextMenu, EventHandler<WindowEvent>>();
    private static Map<Node, EventHandler<MouseEvent>> menuItemNodeMouseExitedEventHandlers = new WeakHashMap<Node, EventHandler<MouseEvent>>();
    private static Map<Node, EventHandler<MouseEvent>> menuItemNodeMouseReleasedEventFilters = new WeakHashMap<Node, EventHandler<MouseEvent>>();

    public static MenuBar fix(MenuBar menuBar) {
        if (menuBar == null) {
            return null;
        }
        ObservableList menus = menuBar.getMenus();
        ListChangeListener<Menu> oldListChangeListener = menuListChangeListeners.get(menus);
        if (oldListChangeListener != null) {
            menus.removeListener(oldListChangeListener);
            menuListChangeListeners.remove(menus);
        }
        ListChangeListener<Menu> newListChangeListener = new ListChangeListener<Menu>(){

            public void onChanged(ListChangeListener.Change<? extends Menu> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (Menu menu : c.getAddedSubList()) {
                        ContextMenuUtil.fix(menu);
                    }
                }
            }
        };
        menus.addListener((ListChangeListener)newListChangeListener);
        menuListChangeListeners.put((ObservableList<Menu>)menus, newListChangeListener);
        for (Menu menu : menus) {
            ContextMenuUtil.fix(menu);
        }
        return menuBar;
    }

    public static Menu fix(Menu menu) {
        if (menu == null) {
            return null;
        }
        ObservableList menuItems = menu.getItems();
        ListChangeListener<MenuItem> oldListChangeListener = menuItemListChangeListeners.get(menuItems);
        if (oldListChangeListener != null) {
            menuItems.removeListener(oldListChangeListener);
            menuItemListChangeListeners.remove(menuItems);
        }
        ListChangeListener<MenuItem> newListChangeListener = new ListChangeListener<MenuItem>(){

            public void onChanged(ListChangeListener.Change<? extends MenuItem> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (MenuItem menuItem : c.getAddedSubList()) {
                        ContextMenuUtil.fix(menuItem);
                    }
                }
            }
        };
        menuItems.addListener((ListChangeListener)newListChangeListener);
        menuItemListChangeListeners.put((ObservableList<MenuItem>)menuItems, newListChangeListener);
        for (MenuItem menuItem : menuItems) {
            ContextMenuUtil.fix(menuItem);
        }
        return menu;
    }

    public static MenuItem fix(MenuItem menuItem) {
        if (menuItem == null) {
            return null;
        }
        ReadOnlyObjectProperty parentPopup = menuItem.parentPopupProperty();
        ChangeListener<ContextMenu> oldChangeListener = parentPopupChangeListeners.get(parentPopup);
        if (oldChangeListener != null) {
            parentPopup.removeListener(oldChangeListener);
            parentPopupChangeListeners.remove(parentPopup);
        }
        ChangeListener<ContextMenu> newChangeListener = new ChangeListener<ContextMenu>(){

            public void changed(ObservableValue<? extends ContextMenu> observable, ContextMenu oldValue, ContextMenu newValue) {
                if (oldValue != null) {
                    ContextMenuUtil.removeListeners(oldValue);
                }
                if (newValue != null) {
                    ContextMenuUtil.fix(newValue, false);
                }
            }
        };
        parentPopup.addListener((ChangeListener)newChangeListener);
        parentPopupChangeListeners.put((ReadOnlyObjectProperty<ContextMenu>)parentPopup, newChangeListener);
        return menuItem;
    }

    public static ContextMenu fix(ContextMenu contextMenu) {
        return ContextMenuUtil.fix(contextMenu, true);
    }

    public static ContextMenu fix(final ContextMenu contextMenu, final boolean hideOnMouseReleased) {
        if (contextMenu == null) {
            return null;
        }
        EventHandler<WindowEvent> oldEventHandler = contextMenuWindowShowingEventHandlers.get(contextMenu);
        if (oldEventHandler != null) {
            contextMenu.removeEventHandler(WindowEvent.WINDOW_SHOWING, oldEventHandler);
            contextMenuWindowShowingEventHandlers.remove(contextMenu);
        }
        EventHandler<WindowEvent> newEventHandler = new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                Node contextMenuNode = contextMenu.getStyleableNode();
                for (MenuItem menuItem : contextMenu.getItems()) {
                    Node menuItemNode = menuItem.getStyleableNode();
                    ContextMenuUtil.fixImpl(contextMenu, contextMenuNode, menuItem, menuItemNode, hideOnMouseReleased);
                }
                contextMenuNode.requestFocus();
                contextMenu.removeEventHandler(WindowEvent.WINDOW_SHOWING, (EventHandler)this);
                contextMenuWindowShowingEventHandlers.remove(contextMenu);
            }
        };
        contextMenu.addEventHandler(WindowEvent.WINDOW_SHOWING, (EventHandler)newEventHandler);
        contextMenuWindowShowingEventHandlers.put(contextMenu, newEventHandler);
        return contextMenu;
    }

    private static void fixImpl(final ContextMenu contextMenu, final Node contextMenuNode, MenuItem menuItem, final Node menuItemNode, final boolean hideOnMouseReleased) {
        if (contextMenu == null) {
            return;
        }
        if (contextMenuNode == null) {
            return;
        }
        if (menuItem == null) {
            return;
        }
        if (menuItemNode == null) {
            return;
        }
        ContextMenuUtil.removeListeners(menuItemNode);
        EventHandler<MouseEvent> newEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                contextMenuNode.requestFocus();
            }
        };
        menuItemNode.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)newEventHandler);
        menuItemNodeMouseExitedEventHandlers.put(menuItemNode, newEventHandler);
        EventHandler<MouseEvent> newEventFilter = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!menuItemNode.isFocused()) {
                    event.consume();
                    if (hideOnMouseReleased) {
                        contextMenu.hide();
                    }
                }
            }
        };
        menuItemNode.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)newEventFilter);
        menuItemNodeMouseReleasedEventFilters.put(menuItemNode, newEventFilter);
    }

    private static void removeListeners(ContextMenu contextMenu) {
        if (contextMenu == null) {
            return;
        }
        for (MenuItem menuItem : contextMenu.getItems()) {
            Node menuItemNode = menuItem.getStyleableNode();
            ContextMenuUtil.removeListeners(menuItemNode);
        }
        EventHandler<WindowEvent> oldEventHandler = contextMenuWindowShowingEventHandlers.get(contextMenu);
        if (oldEventHandler != null) {
            contextMenu.removeEventHandler(WindowEvent.WINDOW_SHOWING, oldEventHandler);
            contextMenuWindowShowingEventHandlers.remove(contextMenu);
        }
    }

    private static void removeListeners(Node menuItemNode) {
        EventHandler<MouseEvent> oldEventFilter;
        if (menuItemNode == null) {
            return;
        }
        EventHandler<MouseEvent> oldEventHandler = menuItemNodeMouseExitedEventHandlers.get(menuItemNode);
        if (oldEventHandler != null) {
            menuItemNode.removeEventHandler(MouseEvent.MOUSE_EXITED, oldEventHandler);
            menuItemNodeMouseExitedEventHandlers.remove(menuItemNode);
        }
        if ((oldEventFilter = menuItemNodeMouseReleasedEventFilters.get(menuItemNode)) != null) {
            menuItemNode.removeEventFilter(MouseEvent.MOUSE_RELEASED, oldEventFilter);
            menuItemNodeMouseReleasedEventFilters.remove(menuItemNode);
        }
    }
}

