/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

@FunctionalInterface
public interface SilentRunnable {
    public void run() throws Exception;

    public static Runnable wrap(SilentRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                }
                SilentRunnable.rethrow(e);
            }
        };
    }

    public static void rethrow(Throwable throwable) {
        SilentRunnable.rethrow0(throwable);
    }

    public static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }
}

