/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.renderer;

import com.codewaves.codehighlight.core.StyleRenderer;

public class HtmlRenderer
implements StyleRenderer {
    private String mPrefix;
    private String mResult;

    public HtmlRenderer(String string) {
        this.mPrefix = string;
    }

    @Override
    public void onStart() {
        this.mResult = "";
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onPushStyle(String string) {
        this.mResult = this.mResult + "<span class=\"" + this.mPrefix + string + "\">";
    }

    @Override
    public void onPopStyle() {
        this.mResult = this.mResult + "</span>";
    }

    @Override
    public void onPushCodeBlock(CharSequence charSequence) {
        this.mResult = this.mResult + this.escape(charSequence.toString());
    }

    @Override
    public void onPushSubLanguage(String string, CharSequence charSequence) {
        this.mResult = this.mResult + "<span class=\"" + string + "\">" + charSequence + "</span>";
    }

    @Override
    public void onAbort(CharSequence charSequence) {
        this.mResult = charSequence.toString();
    }

    @Override
    public CharSequence getResult() {
        return this.mResult;
    }

    private String escape(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

