/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swt;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.ImageCursorFrame;
import com.sun.javafx.tk.Toolkit;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.image.Image;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

class SWTCursors {
    SWTCursors() {
    }

    private static Cursor createCustomCursor(Display display, ImageCursorFrame cursorFrame) {
        Image image = Toolkit.getImageAccessor().fromPlatformImage(cursorFrame.getPlatformImage());
        ImageData imageData = SWTFXUtils.fromFXImage(image, null);
        return new Cursor((Device)display, imageData, (int)cursorFrame.getHotspotX(), (int)cursorFrame.getHotspotY());
    }

    static Cursor embedCursorToCursor(CursorFrame cursorFrame) {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        int id = 0;
        switch (cursorFrame.getCursorType()) {
            case DEFAULT: {
                id = 0;
                break;
            }
            case CROSSHAIR: {
                id = 2;
                break;
            }
            case TEXT: {
                id = 19;
                break;
            }
            case WAIT: {
                id = 1;
                break;
            }
            case SW_RESIZE: {
                id = 16;
                break;
            }
            case SE_RESIZE: {
                id = 15;
                break;
            }
            case NW_RESIZE: {
                id = 17;
                break;
            }
            case NE_RESIZE: {
                id = 14;
                break;
            }
            case N_RESIZE: {
                id = 10;
                break;
            }
            case S_RESIZE: {
                id = 11;
                break;
            }
            case W_RESIZE: {
                id = 13;
                break;
            }
            case E_RESIZE: {
                id = 12;
                break;
            }
            case OPEN_HAND: 
            case CLOSED_HAND: 
            case HAND: {
                id = 21;
                break;
            }
            case MOVE: {
                id = 5;
                break;
            }
            case DISAPPEAR: {
                break;
            }
            case H_RESIZE: {
                id = 9;
                break;
            }
            case V_RESIZE: {
                id = 7;
                break;
            }
            case NONE: {
                return null;
            }
            case IMAGE: {
                return SWTCursors.createCustomCursor(display, (ImageCursorFrame)cursorFrame);
            }
        }
        return display.getSystemCursor(id);
    }
}

