/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import com.vladsch.flexmark.util.sequence.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineCollectingVisitor {
    private final NodeVisitor myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, (Visitor)new Visitor<Text>(){

        public void visit(Text node) {
            LineCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(TextBase.class, (Visitor)new Visitor<TextBase>(){

        public void visit(TextBase node) {
            LineCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HtmlEntity.class, (Visitor)new Visitor<HtmlEntity>(){

        public void visit(HtmlEntity node) {
            LineCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HtmlInline.class, (Visitor)new Visitor<HtmlInline>(){

        public void visit(HtmlInline node) {
            LineCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(SoftLineBreak.class, (Visitor)new Visitor<SoftLineBreak>(){

        public void visit(SoftLineBreak node) {
            LineCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HardLineBreak.class, (Visitor)new Visitor<HardLineBreak>(){

        public void visit(HardLineBreak node) {
            LineCollectingVisitor.this.visit(node);
        }
    })});
    private List<Range> myLines = Collections.EMPTY_LIST;
    private List<Integer> myEOLs;
    private int myStartOffset;
    private int myEndOffset;

    private void finalizeLines() {
        if (this.myStartOffset < this.myEndOffset) {
            Range range = new Range(this.myStartOffset, this.myEndOffset);
            this.myLines.add(range);
            this.myEOLs.add(0);
            this.myStartOffset = this.myEndOffset;
        }
    }

    public List<Range> getLines() {
        this.finalizeLines();
        return this.myLines;
    }

    public List<Integer> getEOLs() {
        this.finalizeLines();
        return this.myEOLs;
    }

    public void collect(Node node) {
        this.myLines = new ArrayList<Range>();
        this.myEOLs = new ArrayList<Integer>();
        this.myStartOffset = node.getStartOffset();
        this.myEndOffset = node.getEndOffset();
        this.myVisitor.visit(node);
    }

    public List<Range> collectAndGetRanges(Node node) {
        this.collect(node);
        return this.getLines();
    }

    private void visit(SoftLineBreak node) {
        Range range = new Range(this.myStartOffset, node.getEndOffset());
        this.myLines.add(range);
        this.myEOLs.add(node.getTextLength());
        this.myStartOffset = node.getEndOffset();
    }

    private void visit(HardLineBreak node) {
        Range range = new Range(this.myStartOffset, node.getEndOffset());
        this.myLines.add(range);
        this.myEOLs.add(node.getTextLength());
        this.myStartOffset = node.getEndOffset();
    }

    private void visit(HtmlEntity node) {
        this.myEndOffset = node.getEndOffset();
    }

    private void visit(HtmlInline node) {
        this.myEndOffset = node.getEndOffset();
    }

    private void visit(Text node) {
        this.myEndOffset = node.getEndOffset();
    }

    private void visit(TextBase node) {
        this.myEndOffset = node.getEndOffset();
    }
}

