/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Collection;
import java.util.Map;

public class Document
extends Block
implements MutableDataHolder {
    private final MutableDataSet dataSet;

    @Override
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public Document(DataHolder options, BasedSequence chars) {
        super(chars);
        this.dataSet = new MutableDataSet(options);
    }

    @Override
    public Map<DataKey, Object> getAll() {
        return this.dataSet.getAll();
    }

    @Override
    public Collection<DataKey> keySet() {
        return this.dataSet.keySet();
    }

    @Override
    public boolean contains(DataKey key) {
        return this.dataSet.contains(key);
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return this.dataSet.get(key);
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        return this.dataSet.setIn(dataHolder);
    }

    @Override
    public int getLineCount() {
        if (this.lineSegments == BasedSequence.EMPTY_LIST) {
            char c = this.getChars().lastChar();
            return (c == '\n' || c == '\r' ? 0 : 1) + this.getLineNumber(this.getChars().length());
        }
        return this.lineSegments.size();
    }

    public int getLineNumber(int offset) {
        if (this.lineSegments == BasedSequence.EMPTY_LIST) {
            BasedSequence preText = this.getChars().baseSubSequence(0, Utils.maxLimit(offset + 1, this.getChars().length()));
            if (preText.isEmpty()) {
                return 0;
            }
            int lineNumber = 0;
            int nextLineEnd = preText.endOfLineAnyEOL(0);
            int length = preText.length();
            while (nextLineEnd < length) {
                int lengthWithEOL = nextLineEnd + preText.eolLength(nextLineEnd);
                if (offset >= lengthWithEOL) {
                    ++lineNumber;
                }
                nextLineEnd = preText.endOfLineAnyEOL(lengthWithEOL);
            }
            return lineNumber;
        }
        int iMax = this.lineSegments.size();
        for (int i = 0; i < iMax; ++i) {
            if (offset >= ((BasedSequence)this.lineSegments.get(i)).getEndOffset()) continue;
            return i;
        }
        return iMax;
    }

    @Override
    public <T> T getOrCompute(DataKey<T> key) {
        return this.dataSet.getOrCompute(key);
    }

    @Override
    public <T> MutableDataHolder remove(DataKey<T> key) {
        return this.dataSet.remove((DataKey)key);
    }

    @Override
    public <T> MutableDataHolder set(DataKey<? extends T> key, T value) {
        return this.dataSet.set((DataKey)key, (Object)value);
    }

    @Override
    public MutableDataHolder setFrom(MutableDataSetter dataSetter) {
        return this.dataSet.setFrom(dataSetter);
    }

    @Override
    public MutableDataHolder setAll(DataHolder other) {
        this.dataSet.setAll(other);
        return this.dataSet;
    }

    @Override
    public MutableDataHolder toMutable() {
        return this.dataSet.toMutable();
    }

    @Override
    public DataHolder toImmutable() {
        return this.dataSet.toImmutable();
    }

    @Override
    public MutableDataHolder clear() {
        throw new UnsupportedOperationException();
    }
}

