/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util;

import com.vladsch.flexmark.util.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImageUtils {
    public static Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Pattern BASE64_ENCODING_PATTERN = Pattern.compile("^data:image/[a-z0-9_-]+;base64,", 2);

    public static Image getImageFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        return ImageUtils.getImageFromTransferable(transferable);
    }

    public static Image getImageFromTransferable(Transferable transferable) {
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                return (Image)transferable.getTransferData(DataFlavor.imageFlavor);
            }
            return null;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return null;
    }

    public static BufferedImage scaleImage(BufferedImage sourceImage, int newWidth, int newHeight, int opType) {
        if (sourceImage == null) {
            return null;
        }
        if (newWidth == 0 || newHeight == 0) {
            return null;
        }
        AffineTransform at = AffineTransform.getScaleInstance((double)newWidth / (double)sourceImage.getWidth(null), (double)newHeight / (double)sourceImage.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(at, opType != 0 ? opType : 2);
        return op.filter(sourceImage, null);
    }

    public static BufferedImage toBufferedImage(Image src) {
        if (src == null) {
            return null;
        }
        if (src instanceof BufferedImage) {
            return (BufferedImage)src;
        }
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        if (w < 0 || h < 0) {
            return null;
        }
        int type = 2;
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static void save(BufferedImage image, File file, String format) {
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (Throwable e) {
            System.out.println("Write error for " + file.getPath() + ": " + e.getMessage());
        }
    }

    public static BufferedImage loadImageFromFile(File cachedImageFile) {
        if (cachedImageFile == null || !cachedImageFile.isFile()) {
            return null;
        }
        try {
            for (int i = 0; i < 3; ++i) {
                BufferedImage read = null;
                try {
                    read = ImageIO.read(cachedImageFile);
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.print("*");
                    System.err.println("could not read" + cachedImageFile);
                    continue;
                }
                if (i > 0) {
                    System.err.println("");
                }
                return read;
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    public static String base64Encode(BufferedImage image) {
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", bos);
            byte[] imageBytes = bos.toByteArray();
            imageString = new String(new BASE64Encoder().encode(imageBytes)).replace("\n", "");
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "data:image/png;base64," + imageString;
    }

    public static String base64Encode(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        try {
            FileInputStream fileInputStreamReader = new FileInputStream(file);
            byte[] imageBytes = new byte[(int)file.length()];
            if (fileInputStreamReader.read(imageBytes) != -1) {
                return "data:image/png;base64," + new String(new BASE64Encoder().encode(imageBytes)).replace("\n", "");
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static BufferedImage base64Decode(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        try {
            String encoded;
            int pos;
            FileInputStream fileInputStreamReader = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            if (fileInputStreamReader.read(bytes) != -1 && (pos = (encoded = new String(bytes, StandardCharsets.UTF_8)).indexOf(44)) >= 0) {
                String encodedImage = encoded.substring(pos + 1);
                byte[] imageBytes = new BASE64Decoder().decodeBuffer(encodedImage);
                ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
                BufferedImage bufferedImage = ImageIO.read(bis);
                bis.close();
                return bufferedImage;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isEncodedImage(String encoded) {
        return encoded != null && encoded.startsWith("data:image/") && BASE64_ENCODING_PATTERN.matcher(encoded).find();
    }

    public static boolean isPossiblyEncodedImage(String encoded) {
        return encoded != null && encoded.startsWith("data:image/");
    }

    public static BufferedImage base64Decode(String encoded) {
        if (encoded == null || encoded.isEmpty()) {
            return null;
        }
        try {
            int pos = encoded.indexOf(44);
            if (pos >= 0) {
                String encodedImage = encoded.substring(pos + 1);
                byte[] imageBytes = new BASE64Decoder().decodeBuffer(encodedImage);
                ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
                BufferedImage bufferedImage = ImageIO.read(bis);
                bis.close();
                return bufferedImage;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static BufferedImage loadImageFromURL(String imageURL) {
        return ImageUtils.loadImageFromURL(imageURL, false);
    }

    public static BufferedImage loadImageFromURL(String imageURL, boolean logImageProcessing) {
        block3: {
            if (imageURL != null) {
                try {
                    BufferedImage image = ImageIO.read(new URL(imageURL));
                    return ImageUtils.toBufferedImage(image);
                }
                catch (IOException e) {
                    if (!logImageProcessing) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius, int borderWidth) {
        if ((float)cornerRadius == 0.0f) {
            return image;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage addBorder(BufferedImage image, Color borderColor, int borderWidth, int cornerRadius) {
        int w = image.getWidth() + borderWidth * 2;
        int h = image.getHeight() + borderWidth * 2;
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setColor(borderColor);
        g2.drawImage(image, borderWidth, borderWidth, image.getWidth(), image.getHeight(), null);
        g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = w - borderWidth - 1;
        int height = h - borderWidth - 1;
        int halfBorder = borderWidth / 2;
        if (cornerRadius > 0) {
            int adjustedRadius = cornerRadius + borderWidth;
            g2.drawRoundRect(halfBorder, halfBorder, width, height, adjustedRadius, adjustedRadius);
        } else {
            g2.drawRect(halfBorder, halfBorder, width, height);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage drawRectangle(BufferedImage image, int x, int y, int w, int h, Color borderColor, int borderWidth, int cornerRadius) {
        return ImageUtils.drawRectangle(image, x, y, w, h, borderColor, borderWidth, cornerRadius, null, 0.0f);
    }

    public static BufferedImage drawRectangle(BufferedImage image, int x, int y, int w, int h, Color borderColor, int borderWidth, int cornerRadius, float[] dash, float dashPhase) {
        boolean invert;
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = output.createGraphics();
        boolean bl = invert = borderColor == null;
        if (invert) {
            int rgb = image.getRGB(x + w / 2, y + h / 2);
            borderColor = Color.getColor("", ~(rgb & 0xFFFFFF));
        }
        g2.drawImage((Image)image, 0, 0, null);
        if (dash != null) {
            g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth, dash, dashPhase));
        } else {
            g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (invert) {
            // empty if block
        }
        g2.setColor(borderColor);
        if (cornerRadius > 0) {
            g2.drawRoundRect(x, y, w, h, cornerRadius, cornerRadius);
        } else {
            g2.drawRect(x, y, w, h);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage drawOval(BufferedImage image, int x, int y, int w, int h, Color borderColor, int borderWidth, float[] dash, float dashPhase) {
        boolean invert;
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = output.createGraphics();
        boolean bl = invert = borderColor == null;
        if (invert) {
            int rgb = image.getRGB(x + w / 2, y + h / 2);
            borderColor = Color.getColor("", ~(rgb & 0xFFFFFF));
        }
        g2.drawImage((Image)image, 0, 0, null);
        if (dash != null) {
            g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth, dash, dashPhase));
        } else {
            g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (invert) {
            // empty if block
        }
        g2.setColor(borderColor);
        g2.drawOval(x, y, w, h);
        g2.dispose();
        return output;
    }

    public static BufferedImage drawHighlightRectangle(BufferedImage image, int x, int y, int w, int h, Color borderColor, int borderWidth, int cornerRadius, Color innerFillColor) {
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int imgW = image.getWidth();
        int imgH = image.getHeight();
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean innerFilled = innerFillColor.getAlpha() != 0;
        g2.drawImage((Image)image, 0, 0, null);
        if (cornerRadius > 0) {
            if (innerFilled) {
                g2.setColor(innerFillColor);
                g2.fillRoundRect(x, y, w, h, cornerRadius, cornerRadius);
            }
            if (borderWidth > 0) {
                g2.setColor(borderColor);
                g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
                g2.drawRoundRect(x, y, w, h, cornerRadius, cornerRadius);
            }
        } else {
            if (innerFilled) {
                g2.setColor(innerFillColor);
                g2.fillRect(x, y, w, h);
            }
            if (borderWidth > 0) {
                g2.setColor(borderColor);
                g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
                g2.drawRect(x, y, w, h);
            }
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage drawHighlightOval(BufferedImage image, int x, int y, int w, int h, Color borderColor, int borderWidth, Color innerFillColor) {
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int imgW = image.getWidth();
        int imgH = image.getHeight();
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean innerFilled = innerFillColor.getAlpha() != 0;
        g2.drawImage((Image)image, 0, 0, null);
        if (innerFilled) {
            g2.setColor(innerFillColor);
            g2.fillOval(x, y, w, h);
        }
        if (borderWidth > 0) {
            g2.setColor(borderColor);
            g2.setStroke(new BasicStroke(borderWidth, 2, 0, borderWidth));
            g2.drawOval(x, y, w, h);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage punchOuterHighlightRectangle(BufferedImage image, BufferedImage outerImage, int x, int y, int w, int h, int borderWidth, int cornerRadius, Color outerFillColor, int outerBorderWidth, int outerCornerRadius, boolean applyToImage) {
        boolean outerFilled;
        boolean bl = outerFilled = outerFillColor.getAlpha() != 0;
        if (!outerFilled) {
            return outerImage;
        }
        BufferedImage output = outerImage != null ? outerImage : new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int imgW = image.getWidth();
        int imgH = image.getHeight();
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (outerImage == null) {
            g2.setColor(outerFillColor);
            if (outerCornerRadius > 0) {
                g2.fillRoundRect(outerBorderWidth, outerBorderWidth, imgW - 2 * outerBorderWidth, imgH - 2 * outerBorderWidth, outerCornerRadius, outerCornerRadius);
            } else {
                g2.fillRect(outerBorderWidth, outerBorderWidth, imgW - 2 * outerBorderWidth, imgH - 2 * outerBorderWidth);
            }
        }
        if (cornerRadius > 0) {
            g2.setColor(TRANSPARENT);
            g2.setComposite(AlphaComposite.Src);
            g2.fillRoundRect(Utils.minLimit(0, x - borderWidth / 2), Utils.minLimit(0, y - borderWidth / 2), w + borderWidth, h + borderWidth, cornerRadius + borderWidth, cornerRadius + borderWidth);
        } else {
            g2.setColor(TRANSPARENT);
            g2.setComposite(AlphaComposite.Src);
            g2.fillRect(Utils.minLimit(0, x - borderWidth / 2), Utils.minLimit(0, y - borderWidth / 2), w + borderWidth, h + borderWidth);
        }
        if (applyToImage) {
            g2.setComposite(AlphaComposite.DstOver);
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage punchOuterHighlightOval(BufferedImage image, BufferedImage outerImage, int x, int y, int w, int h, int borderWidth, Color outerFillColor, int outerBorderWidth, int outerCornerRadius, boolean applyToImage) {
        boolean outerFilled;
        boolean bl = outerFilled = outerFillColor.getAlpha() != 0;
        if (!outerFilled) {
            return outerImage;
        }
        BufferedImage output = outerImage != null ? outerImage : new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int imgW = image.getWidth();
        int imgH = image.getHeight();
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (outerImage == null) {
            g2.setColor(outerFillColor);
            if (outerCornerRadius > 0) {
                g2.fillRoundRect(outerBorderWidth, outerBorderWidth, imgW - 2 * outerBorderWidth, imgH - 2 * outerBorderWidth, outerCornerRadius, outerCornerRadius);
            } else {
                g2.fillRect(outerBorderWidth, outerBorderWidth, imgW - 2 * outerBorderWidth, imgH - 2 * outerBorderWidth);
            }
        }
        g2.setColor(TRANSPARENT);
        g2.setComposite(AlphaComposite.Src);
        g2.fillOval(Utils.minLimit(0, x - borderWidth / 2), Utils.minLimit(0, y - borderWidth / 2), w + borderWidth, h + borderWidth);
        if (applyToImage) {
            g2.setComposite(AlphaComposite.DstOver);
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.dispose();
        return output;
    }

    public static BufferedImage cropImage(BufferedImage image, int trimLeft, int trimRight, int trimTop, int trimBottom) {
        BufferedImage output = image.getSubimage(trimLeft, trimTop, image.getWidth() - trimLeft - trimRight, image.getHeight() - trimTop - trimBottom);
        return output;
    }

    public static BufferedImage removeAlpha(BufferedImage image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), Color.WHITE, null);
        g.dispose();
        return bufferedImage;
    }

    public static Image toTransparent(BufferedImage image, final Color color, final int tolerance) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            int radius;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
                this.radius = tolerance * tolerance * 3;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int delta3;
                int delta2;
                int delta1;
                int radDiff;
                if (tolerance == 0 && (rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                if ((rgb & 0xFF000000) == -16777216 && (radDiff = (delta1 = ((rgb & 0xFF0000) >> 16) - ((this.markerRGB & 0xFF0000) >> 16)) * delta1 + (delta2 = ((rgb & 0xFF00) >> 8) - ((this.markerRGB & 0xFF00) >> 8)) * delta2 + (delta3 = (rgb & 0xFF) - (this.markerRGB & 0xFF)) * delta3) <= this.radius) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static byte[] getImageBytes(BufferedImage image) {
        Object imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", bos);
            byte[] imageBytes = bos.toByteArray();
            bos.close();
            return imageBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

