/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.renderer;

import com.codewaves.codehighlight.core.StyleRenderer;

public class HtmlRenderer
implements StyleRenderer {
    private String mPrefix;
    private String mResult;

    public HtmlRenderer(String prefix) {
        this.mPrefix = prefix;
    }

    @Override
    public void onStart() {
        this.mResult = "";
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onPushStyle(String style) {
        this.mResult = String.valueOf(this.mResult) + "<span class=\"" + this.mPrefix + style + "\">";
    }

    @Override
    public void onPopStyle() {
        this.mResult = String.valueOf(this.mResult) + "</span>";
    }

    @Override
    public void onPushCodeBlock(CharSequence block) {
        this.mResult = String.valueOf(this.mResult) + this.escape(block.toString());
    }

    @Override
    public void onPushSubLanguage(String name, CharSequence code) {
        this.mResult = String.valueOf(this.mResult) + "<span class=\"" + name + "\">" + code + "</span>";
    }

    @Override
    public void onAbort(CharSequence code) {
        this.mResult = code.toString();
    }

    @Override
    public CharSequence getResult() {
        return this.mResult;
    }

    private String escape(String code) {
        return code.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

