/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import org.logi.crypto.Crypto;
import org.logi.crypto.CryptoCorruptError;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.keys.Key;

public abstract class K
extends Crypto
implements Key {
    protected Fingerprint fingerprint;
    protected Fingerprint otherFingerprint;

    protected abstract Fingerprint calcFingerprint(boolean var1, String var2) throws InvalidCDSException;

    public final Fingerprint getFingerprint() {
        String string = HashState.getDefaultHashFunction();
        if (this.fingerprint == null || !this.fingerprint.getName().equals(string)) {
            try {
                this.fingerprint = this.calcFingerprint(false, string);
            }
            catch (InvalidCDSException invalidCDSException) {
                throw new CryptoCorruptError("The HashState object for " + string + " has disappeared.");
            }
        }
        return this.fingerprint;
    }

    public final Fingerprint getFingerprint(String string) throws InvalidCDSException {
        if (string.equals(HashState.getDefaultHashFunction())) {
            return this.getFingerprint();
        }
        return this.calcFingerprint(false, string);
    }

    public Fingerprint matchFingerprint() {
        String string = HashState.getDefaultHashFunction();
        if (this.fingerprint == null || !this.fingerprint.getName().equals(string)) {
            try {
                this.fingerprint = this.calcFingerprint(true, string);
            }
            catch (InvalidCDSException invalidCDSException) {
                throw new CryptoCorruptError("The HashState object for " + string + " has disappeared.");
            }
        }
        return this.fingerprint;
    }

    public Fingerprint matchFingerprint(String string) throws InvalidCDSException {
        if (string.equals(HashState.getDefaultHashFunction())) {
            return this.getFingerprint();
        }
        return this.calcFingerprint(true, string);
    }

    public final int hashCode() {
        return this.getFingerprint().hashCode();
    }

    public abstract int getSize();

    public abstract String getAlgorithm();

    public abstract boolean isPrivate();

    public abstract boolean matches(Key var1);
}

