/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.filetypes.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.jdic.filetypes.Action;
import org.jdesktop.jdic.filetypes.Association;
import org.jdesktop.jdic.filetypes.RegisterFailedException;
import org.jdesktop.jdic.filetypes.internal.AppAssociationWriter;
import org.jdesktop.jdic.filetypes.internal.AppUtility;
import org.jdesktop.jdic.filetypes.internal.GnomeAssociationUtil;

public class GnomeAppAssociationWriter
implements AppAssociationWriter {
    static String GNOMEDIR_VALUE = GnomeAssociationUtil.getEnv("GNOMEDIR");
    static String GNOME_LINUX_SYSTEM_SHARE_DIR = GNOMEDIR_VALUE == null ? "/usr/share/" : GNOMEDIR_VALUE + "/share/";
    static String GNOME_SOLARIS_SYSTEM_SHARE_DIR = "/usr/share/gnome/";
    static String GNOME_LINUX_SYSTEM_MIME_INFO_DIR = GNOME_LINUX_SYSTEM_SHARE_DIR + "mime-info/";
    static String GNOME_SOLARIS_SYSTEM_MIME_INFO_DIR = GNOME_SOLARIS_SYSTEM_SHARE_DIR + "mime-info/";
    static String GNOME_LINUX_SYSTEM_APPLICATION_REGISTRY_DIR = GNOME_LINUX_SYSTEM_SHARE_DIR + "application-registry/";
    static String GNOME_SOLARIS_SYSTEM_APPLICATION_REGISTRY_DIR = GNOME_SOLARIS_SYSTEM_SHARE_DIR + "application-registry/";
    static String OSNAME = System.getProperty("os.name").toLowerCase();
    static String GNOME_SYSTEM_MIME_INFO_DIR = OSNAME.equals("linux") ? GNOME_LINUX_SYSTEM_MIME_INFO_DIR : GNOME_SOLARIS_SYSTEM_MIME_INFO_DIR;
    static String GNOME_SYSTEM_APPLICATION_REGISTRY_DIR = OSNAME.equals("linux") ? GNOME_LINUX_SYSTEM_APPLICATION_REGISTRY_DIR : GNOME_SOLARIS_SYSTEM_APPLICATION_REGISTRY_DIR;
    static String GNOME_USER_MIME_INFO_DIR = System.getProperty("user.home") + "/.gnome/mime-info/";
    static String GNOME_USER_APPLICATION_INFO_DIR = System.getProperty("user.home") + "/.gnome/application-info/";
    static String MIME_SUFFIX = ".mime";
    static String KEYS_SUFFIX = ".keys";
    static String APPLICATIONS_SUFFIX = ".applications";
    private String defaultAppID = null;
    private String defaultAppCommand = null;

    private String fileExtListToString(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2 == null) continue;
                string2 = AppUtility.removeDotFromFileExtension(string2);
                if (string.length() == 0) {
                    string = string.concat(string2);
                    continue;
                }
                string = string.concat(' ' + string2);
            }
        } else {
            string = null;
        }
        return string;
    }

    private String getSystemDotMimeFilePath(Association association) {
        return GNOME_SYSTEM_MIME_INFO_DIR + association.getName() + MIME_SUFFIX;
    }

    private String getSystemDotKeysFilePath(Association association) {
        return GNOME_SYSTEM_MIME_INFO_DIR + association.getName() + KEYS_SUFFIX;
    }

    private String getSystemDotApplicationsFilePath(Association association) {
        return GNOME_SYSTEM_APPLICATION_REGISTRY_DIR + association.getName() + APPLICATIONS_SUFFIX;
    }

    private String getUserDotMimeFilePath(Association association) {
        return GNOME_USER_MIME_INFO_DIR + association.getName() + MIME_SUFFIX;
    }

    private String getUserDotKeysFilePath(Association association) {
        return GNOME_USER_MIME_INFO_DIR + association.getName() + KEYS_SUFFIX;
    }

    private String getUserDotApplicationsFilePath(Association association) {
        return GNOME_USER_APPLICATION_INFO_DIR + association.getName() + APPLICATIONS_SUFFIX;
    }

    private void checkSystemMIMEDatabase() throws IOException {
        File file = null;
        file = new File(GNOME_SYSTEM_MIME_INFO_DIR);
        if (!file.exists()) {
            throw new IOException("The system MIME info directory doesn't exist: " + GNOME_SYSTEM_MIME_INFO_DIR + ". Make sure Gnome 2.0+ is installed and env GNOMEDIR is set properly.");
        }
        file = new File(GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        if (!file.exists()) {
            throw new IOException("The system MIME info directory doesn't exist: " + GNOME_SYSTEM_APPLICATION_REGISTRY_DIR + ". Make sure Gnome 2.0+ is installed and env GNOMEDIR is set properly.");
        }
        file = new File(GNOME_SYSTEM_MIME_INFO_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the system MIME info directory: " + GNOME_SYSTEM_MIME_INFO_DIR);
        }
        file = new File(GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the system MIME info directory: " + GNOME_SYSTEM_APPLICATION_REGISTRY_DIR);
        }
    }

    private void checkUserMIMEDatabase() throws IOException {
        boolean bl;
        File file = null;
        file = new File(GNOME_USER_MIME_INFO_DIR);
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("The user MIME info directory doesn't exist, and fails to be created: " + GNOME_USER_MIME_INFO_DIR);
        }
        file = new File(GNOME_USER_APPLICATION_INFO_DIR);
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("The user MIME info directory doesn't exist, and fails to be created: " + GNOME_USER_APPLICATION_INFO_DIR);
        }
        file = new File(GNOME_USER_MIME_INFO_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the user MIME info directory: " + GNOME_USER_MIME_INFO_DIR);
        }
        file = new File(GNOME_USER_APPLICATION_INFO_DIR);
        if (!file.canWrite()) {
            throw new IOException("No write permission to the user MIME info directory: " + GNOME_USER_MIME_INFO_DIR);
        }
    }

    private void createFile(String string) throws IOException {
        boolean bl = false;
        File file = new File(string);
        if (!file.exists() && !(bl = file.createNewFile())) {
            throw new IOException("Create MIME file: " + string + " failed.");
        }
    }

    private void parseOpenAction(Association association) {
        List list = association.getActionList();
        if (list == null) {
            return;
        }
        String string = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && this.defaultAppCommand == null) {
            Action action = (Action)iterator.next();
            string = action.getVerb();
            if (!string.equalsIgnoreCase("open")) continue;
            this.defaultAppCommand = action.getCommand().trim();
        }
        if (this.defaultAppCommand != null) {
            int n = this.defaultAppCommand.lastIndexOf(File.separator);
            this.defaultAppID = n == -1 || n == this.defaultAppCommand.length() - 1 ? this.defaultAppCommand : this.defaultAppCommand.substring(n + 1, this.defaultAppCommand.length());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeDotMimeFile(Association association, String string) throws IOException {
        this.createFile(string);
        String string2 = association.getMimeType();
        List list = association.getFileExtList();
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                bufferedWriter.write(string2 + "\n");
                String string3 = null;
                string3 = list == null ? "" : this.fileExtListToString(list);
                bufferedWriter.write("\text: " + string3 + "\n");
                bufferedWriter.write("\n");
            }
            catch (IOException iOException) {
                throw new IOException("Write mime info to " + string + " failed.");
            }
            Object var8_8 = null;
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedWriter.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeDotKeysFile(Association association, String string) throws IOException {
        this.createFile(string);
        String string2 = association.getMimeType();
        String string3 = association.getDescription();
        String string4 = association.getIconFileName();
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                bufferedWriter.write(string2 + "\n");
                if (string3 != null) {
                    bufferedWriter.write("\tdescription=" + string3 + "\n");
                }
                if (string4 != null) {
                    bufferedWriter.write("\ticon_filename=" + string4 + "\n");
                }
                this.parseOpenAction(association);
                if (this.defaultAppID != null) {
                    bufferedWriter.write("\tdefault_action_type=application\n");
                    bufferedWriter.write("\tdefault_application_id=" + this.defaultAppID + "\n");
                    bufferedWriter.write("\tshort_list_application_user_additions=" + this.defaultAppID + "\n");
                }
                bufferedWriter.write("\n");
            }
            catch (IOException iOException) {
                throw new IOException("Write mime info to " + string + " failed.");
            }
            Object var9_7 = null;
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedWriter.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeDotApplicationsFile(Association association, String string) throws IOException {
        this.createFile(string);
        BufferedWriter bufferedWriter = null;
        try {
            try {
                this.parseOpenAction(association);
                if (this.defaultAppID != null && this.defaultAppCommand != null) {
                    bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                    bufferedWriter.write(this.defaultAppID + "\n");
                    bufferedWriter.write("\tcommand=" + this.defaultAppCommand + "\n");
                    bufferedWriter.write("\tname=" + this.defaultAppID + "\n");
                    bufferedWriter.write("\tcan_open_multiple_files=false\n");
                    bufferedWriter.write("\trequires_terminal=false\n");
                    String string2 = association.getMimeType();
                    bufferedWriter.write("\tmime_types=" + string2 + "\n");
                    bufferedWriter.write("\n");
                }
            }
            catch (IOException iOException) {
                throw new IOException("Write mime info to " + string + " failed.");
            }
            Object var6_6 = null;
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedWriter.close();
        return;
    }

    private boolean dotMimeFileContainsMimeType(File file, String string) {
        boolean bl = false;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            bufferedReader.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void checkAssociationValidForRegistration(Association association) throws IllegalArgumentException {
        if (association.getName() == null || association.getMimeType() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the name and mimeType fields to perform this operation.");
        }
    }

    public void checkAssociationValidForUnregistration(Association association) throws IllegalArgumentException {
        if (association.getName() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify the name field to perform this operation.");
        }
    }

    public boolean isAssociationExist(Association association, int n) {
        File file = null;
        file = n == 2 ? new File(this.getSystemDotMimeFilePath(association)) : new File(this.getUserDotMimeFilePath(association));
        if (file.exists()) {
            if (association.getMimeType() == null) {
                return true;
            }
            return this.dotMimeFileContainsMimeType(file, association.getMimeType());
        }
        return false;
    }

    public void registerAssociation(Association association, int n) throws RegisterFailedException {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (n == 2) {
                this.checkSystemMIMEDatabase();
                string = this.getSystemDotMimeFilePath(association);
                string2 = this.getSystemDotKeysFilePath(association);
                string3 = this.getSystemDotApplicationsFilePath(association);
            } else {
                this.checkUserMIMEDatabase();
                string = this.getUserDotMimeFilePath(association);
                string2 = this.getUserDotKeysFilePath(association);
                string3 = this.getUserDotApplicationsFilePath(association);
            }
            this.writeDotMimeFile(association, string);
            this.writeDotKeysFile(association, string2);
            this.writeDotApplicationsFile(association, string3);
        }
        catch (IOException iOException) {
            if (string != null) {
                new File(string).delete();
            }
            if (string2 != null) {
                new File(string2).delete();
            }
            if (string3 != null) {
                new File(string3).delete();
            }
            throw new RegisterFailedException(iOException.getMessage());
        }
    }

    public void unregisterAssociation(Association association, int n) throws RegisterFailedException {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (n == 2) {
                this.checkSystemMIMEDatabase();
                string = this.getSystemDotMimeFilePath(association);
                string2 = this.getSystemDotKeysFilePath(association);
                string3 = this.getSystemDotApplicationsFilePath(association);
            } else {
                this.checkUserMIMEDatabase();
                string = this.getUserDotMimeFilePath(association);
                string2 = this.getUserDotKeysFilePath(association);
                string3 = this.getUserDotApplicationsFilePath(association);
            }
            new File(string).delete();
            new File(string2).delete();
            new File(string3).delete();
        }
        catch (IOException iOException) {
            throw new RegisterFailedException(iOException.getMessage());
        }
    }
}

