/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.DaapResponseFactory;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.chunks.LoginResponseImpl;
import de.kapsi.net.daap.chunks.UpdateResponseImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapRequestProcessor {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapRequestProcessor == null ? (class$de$kapsi$net$daap$DaapRequestProcessor = DaapRequestProcessor.class$("de.kapsi.net.daap.DaapRequestProcessor")) : class$de$kapsi$net$daap$DaapRequestProcessor));
    private static final String ISO_8859_1 = "8859_1";
    private DaapResponseFactory factory;
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapRequestProcessor;

    public DaapRequestProcessor(DaapResponseFactory factory) {
        this.factory = factory;
    }

    public DaapResponse process(DaapRequest request) throws IOException {
        if (request == null || request.isUnknownRequest()) {
            throw new IOException("Unknown request: " + request);
        }
        if (request.isSongRequest()) {
            return this.processSongRequest(request);
        }
        if (request.isServerInfoRequest()) {
            return this.processServerInfoRequest(request);
        }
        if (request.isLogoutRequest()) {
            return this.processLogoutRequest(request);
        }
        if (!this.isAuthenticated(request)) {
            return this.factory.createAuthResponse(request);
        }
        if (request.isContentCodesRequest()) {
            return this.processContentCodesRequest(request);
        }
        if (request.isLoginRequest()) {
            return this.processLoginRequest(request);
        }
        if (this.validateSessionId(request)) {
            if (request.isUpdateRequest()) {
                return this.processUpdateRequest(request);
            }
            if (request.isDatabasesRequest()) {
                return this.processDatabasesRequest(request);
            }
            if (request.isDatabaseSongsRequest()) {
                return this.processDatabaseSongsRequest(request);
            }
            if (request.isDatabasePlaylistsRequest()) {
                return this.processDatabasePlaylistsRequest(request);
            }
            if (request.isPlaylistSongsRequest()) {
                return this.processPlaylistSongsRequest(request);
            }
            if (request.isResolveRequest()) {
                return this.processResolveRequest(request);
            }
        } else {
            throw new IOException("Invalid session-id: " + request);
        }
        throw new IOException("Unhandled request: " + request);
    }

    private boolean isAuthenticated(DaapRequest request) throws UnsupportedEncodingException {
        boolean authenticated = request.isServerSideRequest();
        if (!authenticated) {
            Header authHeader;
            DaapConnection connection = request.getConnection();
            DaapServer server = connection.getServer();
            DaapAuthenticator authenticator = server.getAuthenticator();
            boolean bl = authenticated = authenticator == null || !authenticator.requiresAuthentication();
            if (!authenticated && (authHeader = request.getHeader("Authorization")) != null) {
                int q;
                StringTokenizer tok = new StringTokenizer(authHeader.getValue(), " ");
                if (!tok.nextToken().equals("Basic")) {
                    return false;
                }
                byte[] logpass = Base64.decode((byte[])tok.nextToken().getBytes(ISO_8859_1));
                for (q = 0; q < logpass.length && logpass[q] != 58; ++q) {
                }
                String username = new String(logpass, 0, q);
                String password = "";
                if (logpass.length - ++q != 0) {
                    password = new String(logpass, q, logpass.length - q);
                }
                if (!(authenticated = authenticator.authenticate(username, password)) && LOG.isInfoEnabled()) {
                    LOG.info((Object)"Wrong username or password");
                }
            }
        }
        return authenticated;
    }

    private boolean validateSessionId(DaapRequest request) {
        DaapConnection connection = request.getConnection();
        DaapSession session = connection.getSession(false);
        if (session != null) {
            return session.getSessionId().intValue() == request.getSessionId();
        }
        return false;
    }

    protected DaapResponse processServerInfoRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        byte[] data = (byte[])server.getLibrary().select(request);
        if (data == null) {
            throw new IOException("library.select(ServerInfoRequest) returned null");
        }
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processContentCodesRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        byte[] data = (byte[])server.getLibrary().select(request);
        if (data == null) {
            throw new IOException("library.select(ContentCodesRequest) returned null");
        }
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processLoginRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        Integer sessionId = connection.getSession(true).getSessionId();
        LoginResponseImpl login = new LoginResponseImpl(sessionId);
        byte[] data = DaapUtil.serialize(login, true);
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processLogoutRequest(DaapRequest request) throws IOException {
        throw new IOException("Logout");
    }

    protected DaapResponse processUpdateRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        Integer revision = (Integer)server.getLibrary().select(request);
        if (revision == null) {
            throw new IOException("library.select(UpdateRequest) returned null-Revision");
        }
        DaapSession session = connection.getSession(false);
        if (revision.intValue() == request.getDelta() && revision != 0) {
            session.setAttribute("DELTA", new Integer(request.getDelta()));
            session.setAttribute("REVISION-NUMBER", new Integer(request.getRevisionNumber()));
            session.removeAttribute("UPDATE_LOCK");
            return null;
        }
        session.setAttribute("UPDATE_LOCK", "UPDATE_LOCK");
        UpdateResponseImpl update = new UpdateResponseImpl(revision);
        byte[] data = DaapUtil.serialize(update, true);
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processDatabasesRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        byte[] serverDatabases = (byte[])server.getLibrary().select(request);
        if (serverDatabases == null) {
            throw new IOException("library.select(DatabasesRequest) returned null");
        }
        return this.factory.createChunkResponse(request, serverDatabases);
    }

    protected DaapResponse processDatabaseSongsRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        byte[] databaseSongs = (byte[])server.getLibrary().select(request);
        if (databaseSongs == null) {
            throw new IOException("library.select(DatabaseSongsRequest) returned null");
        }
        return this.factory.createChunkResponse(request, databaseSongs);
    }

    protected DaapResponse processDatabasePlaylistsRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        byte[] databasePlaylists = (byte[])server.getLibrary().select(request);
        if (databasePlaylists == null) {
            throw new IOException("library.select(DatabasePlaylists) returned null");
        }
        return this.factory.createChunkResponse(request, databasePlaylists);
    }

    protected DaapResponse processPlaylistSongsRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        byte[] playlistSongs = (byte[])server.getLibrary().select(request);
        if (playlistSongs == null) {
            throw new IOException("library.select(PlaylistSongs) returned null");
        }
        return this.factory.createChunkResponse(request, playlistSongs);
    }

    protected DaapResponse processResolveRequest(DaapRequest request) throws IOException {
        throw new IOException("Resolve is not implemented");
    }

    protected DaapResponse processSongRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        DaapStreamSource streamSource = server.getStreamSource();
        if (streamSource != null) {
            FileInputStream in;
            int[] range = this.getRange(request);
            if (range == null) {
                throw new IOException("getRange returned null");
            }
            int pos = range[0];
            int end = range[1];
            Song song = (Song)server.getLibrary().select(request);
            if (song == null) {
                throw new IOException("Library returned null-Song for request: " + request);
            }
            if (end == -1) {
                end = song.getSize();
            }
            if ((in = streamSource.getSource(song)) == null) {
                throw new IOException("Unknown source for Song: " + song);
            }
            return this.factory.createAudioResponse(request, song, in, pos, end);
        }
        return null;
    }

    private int[] getRange(DaapRequest request) throws IOException {
        Header rangeHeader = request.getHeader("Range");
        if (rangeHeader != null) {
            try {
                int q;
                StringTokenizer tok = new StringTokenizer(rangeHeader.getValue(), "=");
                String key = tok.nextToken().trim();
                if (!key.equals("bytes")) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Unknown range type: " + key));
                    }
                    return null;
                }
                byte[] range = tok.nextToken().getBytes(ISO_8859_1);
                for (q = 0; q < range.length && range[q] != 45; ++q) {
                }
                int pos = -1;
                int end = -1;
                pos = Integer.parseInt(new String(range, 0, q));
                if (range.length - ++q != 0) {
                    end = Integer.parseInt(new String(range, q, range.length - q));
                }
                return new int[]{pos, end};
            }
            catch (NoSuchElementException err) {
                LOG.error((Object)err);
            }
            catch (NumberFormatException err) {
                LOG.error((Object)err);
            }
        }
        return new int[]{0, -1};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

