/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import org.logi.crypto.Crypto;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.InterAuthClient;
import org.logi.crypto.protocols.QRAuth;
import org.logi.crypto.protocols.ValidationException;

public class QRAuthClient
extends QRAuth
implements InterAuthClient {
    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        try {
            if (this.r == null) {
                if (byArray != null) {
                    throw new CryptoProtocolException("The client should always send the first message");
                }
                this.r = new byte[this.key.plainBlockSize()];
                random.nextBytes(this.r);
                byte[] byArray2 = new byte[this.key.cipherBlockSize()];
                this.key.encrypt(this.r, 0, byArray2, 0);
                return byArray2;
            }
            if (byArray.length != this.key.cipherBlockSize()) {
                throw new CryptoProtocolException("Received message has the wrong length.");
            }
            byte[] byArray3 = new byte[this.key.cipherBlockSize()];
            this.key.decrypt(byArray, 0, byArray3, 0);
            QRAuth.addOne(this.r);
            if (!Crypto.equal(byArray3, this.r)) {
                throw new ValidationException("The server does not know the secret");
            }
            QRAuth.addOne(this.r);
            byte[] byArray4 = new byte[this.key.cipherBlockSize()];
            this.key.encrypt(this.r, 0, byArray4, 0);
            this.completed = true;
            return byArray4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public QRAuthClient(CipherKey cipherKey) {
        super(cipherKey);
    }
}

