/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.SymmetricKey;

public class DESKey
extends SymmetricKey
implements CipherKey {
    private static final byte[] PC1 = new byte[]{56, 48, 40, 32, 24, 16, 8, 0, 57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 60, 52, 44, 36, 28, 20, 12, 4, 27, 19, 11, 3};
    private static final byte[] PC2 = new byte[]{21, 24, 18, 31, 8, 12, 10, 35, 22, 13, 28, 17, 30, 26, 19, 11, 33, 15, 23, 14, 34, 27, 20, 9, 48, 59, 38, 44, 54, 62, 37, 47, 58, 52, 40, 55, 51, 56, 46, 63, 41, 60, 53, 49, 57, 43, 36, 39};
    private static final int[] S1 = new int[]{0x808200, 0, 32768, 0x808202, 0x808002, 33282, 2, 32768, 512, 0x808200, 0x808202, 512, 0x800202, 0x808002, 0x800000, 2, 514, 0x800200, 0x800200, 33280, 33280, 0x808000, 0x808000, 0x800202, 32770, 0x800002, 0x800002, 32770, 0, 514, 33282, 0x800000, 32768, 0x808202, 2, 0x808000, 0x808200, 0x800000, 0x800000, 512, 0x808002, 32768, 33280, 0x800002, 512, 2, 0x800202, 33282, 0x808202, 32770, 0x808000, 0x800202, 0x800002, 514, 33282, 0x808200, 514, 0x800200, 0x800200, 0, 32770, 33280, 0, 0x808002};
    private static final int[] S2 = new int[]{1074282512, 0x40004000, 16384, 540688, 524288, 16, 1074266128, 0x40004010, 0x40000010, 1074282512, 0x40084000, 0x40000000, 0x40004000, 524288, 16, 1074266128, 540672, 524304, 0x40004010, 0, 0x40000000, 16384, 540688, 0x40080000, 524304, 0x40000010, 0, 540672, 16400, 0x40084000, 0x40080000, 16400, 0, 540688, 1074266128, 524288, 0x40004010, 0x40080000, 0x40084000, 16384, 0x40080000, 0x40004000, 16, 1074282512, 540688, 16, 16384, 0x40000000, 16400, 0x40084000, 524288, 0x40000010, 524304, 0x40004010, 0x40000010, 524304, 540672, 0, 0x40004000, 16400, 0x40000000, 1074266128, 1074282512, 540672};
    private static final int[] S3 = new int[]{260, 0x4010100, 0, 0x4010004, 0x4000100, 0, 65796, 0x4000100, 65540, 0x4000004, 0x4000004, 65536, 0x4010104, 65540, 0x4010000, 260, 0x4000000, 4, 0x4010100, 256, 65792, 0x4010000, 0x4010004, 65796, 0x4000104, 65792, 65536, 0x4000104, 4, 0x4010104, 256, 0x4000000, 0x4010100, 0x4000000, 65540, 260, 65536, 0x4010100, 0x4000100, 0, 256, 65540, 0x4010104, 0x4000100, 0x4000004, 256, 0, 0x4010004, 0x4000104, 65536, 0x4000000, 0x4010104, 4, 65796, 65792, 0x4000004, 0x4010000, 0x4000104, 260, 0x4010000, 65796, 4, 0x4010004, 65792};
    private static final int[] S4 = new int[]{-2143285248, -2147479488, -2147479488, 64, 0x401040, -2143289280, -2143289344, -2147479552, 0, 0x401000, 0x401000, -2143285184, -2147483584, 0, 0x400040, -2143289344, Integer.MIN_VALUE, 4096, 0x400000, -2143285248, 64, 0x400000, -2147479552, 4160, -2143289280, Integer.MIN_VALUE, 4160, 0x400040, 4096, 0x401040, -2143285184, -2147483584, 0x400040, -2143289344, 0x401000, -2143285184, -2147483584, 0, 0, 0x401000, 4160, 0x400040, -2143289280, Integer.MIN_VALUE, -2143285248, -2147479488, -2147479488, 64, -2143285184, -2147483584, Integer.MIN_VALUE, 4096, -2143289344, -2147479552, 0x401040, -2143289280, -2147479552, 4160, 0x400000, -2143285248, 64, 0x400000, 4096, 0x401040};
    private static final int[] S5 = new int[]{128, 17039488, 0x1040000, 553648256, 262144, 128, 0x20000000, 0x1040000, 537133184, 262144, 0x1000080, 537133184, 553648256, 553910272, 262272, 0x20000000, 0x1000000, 0x20040000, 0x20040000, 0, 0x20000080, 553910400, 553910400, 0x1000080, 553910272, 0x20000080, 0, 0x21000000, 17039488, 0x1000000, 0x21000000, 262272, 262144, 553648256, 128, 0x1000000, 0x20000000, 0x1040000, 553648256, 537133184, 0x1000080, 0x20000000, 553910272, 17039488, 537133184, 128, 0x1000000, 553910272, 553910400, 262272, 0x21000000, 553910400, 0x1040000, 0, 0x20040000, 0x21000000, 262272, 0x1000080, 0x20000080, 262144, 0, 0x20040000, 17039488, 0x20000080};
    private static final int[] S6 = new int[]{0x10000008, 0x10200000, 8192, 270540808, 0x10200000, 8, 270540808, 0x200000, 0x10002000, 0x202008, 0x200000, 0x10000008, 0x200008, 0x10002000, 0x10000000, 8200, 0, 0x200008, 268443656, 8192, 0x202000, 268443656, 8, 270532616, 270532616, 0, 0x202008, 0x10202000, 8200, 0x202000, 0x10202000, 0x10000000, 0x10002000, 8, 270532616, 0x202000, 270540808, 0x200000, 8200, 0x10000008, 0x200000, 0x10002000, 0x10000000, 8200, 0x10000008, 270540808, 0x202000, 0x10200000, 0x202008, 0x10202000, 0, 270532616, 8, 8192, 0x10200000, 0x202008, 8192, 0x200008, 268443656, 0, 0x10202000, 0x10000000, 0x200008, 268443656};
    private static final int[] S7 = new int[]{0x100000, 0x2100001, 33555457, 0, 1024, 33555457, 0x100401, 34604032, 34604033, 0x100000, 0, 0x2000001, 1, 0x2000000, 0x2100001, 1025, 0x2000400, 0x100401, 0x100001, 0x2000400, 0x2000001, 0x2100000, 34604032, 0x100001, 0x2100000, 1024, 1025, 34604033, 0x100400, 1, 0x2000000, 0x100400, 0x2000000, 0x100400, 0x100000, 33555457, 33555457, 0x2100001, 0x2100001, 1, 0x100001, 0x2000000, 0x2000400, 0x100000, 34604032, 1025, 0x100401, 34604032, 1025, 0x2000001, 34604033, 0x2100000, 0x100400, 0, 1, 34604033, 0, 0x100401, 0x2100000, 1024, 0x2000001, 0x2000400, 1024, 0x100001};
    private static final int[] S8 = new int[]{0x8000820, 2048, 131072, 0x8020820, 0x8000000, 0x8000820, 32, 0x8000000, 131104, 0x8020000, 0x8020820, 133120, 0x8020800, 133152, 2048, 32, 0x8020000, 0x8000020, 0x8000800, 2080, 133120, 131104, 0x8020020, 0x8020800, 2080, 0, 0, 0x8020020, 0x8000020, 0x8000800, 133152, 131072, 133152, 131072, 0x8020800, 2048, 32, 0x8020020, 2048, 133152, 0x8000800, 32, 0x8000020, 0x8020000, 0x8020020, 0x8000000, 131072, 0x8000820, 0, 0x8020820, 131104, 0x8000020, 0x8020000, 0x8000800, 0x8000820, 0, 0x8020820, 133120, 133120, 2080, 2080, 131104, 0x8000000, 0x8020800};
    protected static final byte[] IP = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7, 56, 48, 40, 32, 24, 16, 8, 0, 58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6};
    protected static final byte[] FP = new byte[]{39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25, 32, 0, 40, 8, 48, 16, 56, 24};
    private long key;
    private long[] subKeys;

    public static DESKey parseCDS(String string) throws InvalidCDSException {
        int n = 0;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n == string.length()) {
            throw new InvalidCDSException("Empty argument in DESKey(String)");
        }
        int n2 = string.length() - 1;
        while (n2 >= 0 && Character.isWhitespace(string.charAt(n2))) {
            --n2;
        }
        long l = n2 == n && string.charAt(n) == '?' ? random.nextLong() : Crypto.makeLong(Crypto.fromHexString(string.substring(n, n2 + 1)), 0, 8);
        return new DESKey(l);
    }

    public int plainBlockSize() {
        return 8;
    }

    public int cipherBlockSize() {
        return 8;
    }

    public int getSize() {
        return 56;
    }

    public String getAlgorithm() {
        return "DES";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.key == ((DESKey)object).key;
    }

    public byte[] getKey() {
        byte[] byArray = new byte[8];
        Crypto.writeBytes(this.key, byArray, 0, 8);
        return byArray;
    }

    public String toString() {
        return "DESKey(" + Crypto.hexString(this.key) + ")";
    }

    private void buildSubKeys() {
        long l = Crypto.pickBits(this.key, PC1);
        this.subKeys = new long[16];
        int n = 0;
        while (n < 16) {
            l = n == 0 || n == 1 || n == 8 || n == 15 ? l << 1 & 0xFFFFFFEFFFFFFEL | l >>> 27 & 0x10000001L : l << 2 & 0xFFFFFFCFFFFFFCL | l >>> 26 & 0x30000003L;
            this.subKeys[n] = Crypto.pickBits(l, PC2);
            ++n;
        }
    }

    private static final int f(int n, long l) {
        return S1[(int)((long)(n << 5 & 0x20 | n >>> 27 & 0x1F) ^ l >>> 42 & 0x3FL)] | S2[(int)((long)(n >>> 23 & 0x3F) ^ l >>> 36 & 0x3FL)] | S3[(int)((long)(n >>> 19 & 0x3F) ^ l >>> 30 & 0x3FL)] | S4[(int)((long)(n >>> 15 & 0x3F) ^ l >>> 24 & 0x3FL)] | S5[(int)((long)(n >>> 11 & 0x3F) ^ l >>> 18 & 0x3FL)] | S6[(int)((long)(n >>> 7 & 0x3F) ^ l >>> 12 & 0x3FL)] | S7[(int)((long)(n >>> 3 & 0x3F) ^ l >>> 6 & 0x3FL)] | S8[(int)((long)(n >>> 31 & 1 | n << 1 & 0x3E) ^ l & 0x3FL)];
    }

    protected long subCrypt(long l) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        int n3 = 0;
        while (n3 < 16) {
            int n4 = n;
            n = n2;
            n2 = n4 ^ DESKey.f(n2, this.subKeys[n3]);
            ++n3;
        }
        return (long)n2 << 32 | (long)n & 0xFFFFFFFFL;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        long l = Crypto.makeLong(byArray, n, 8);
        l = Crypto.pickBits(l, IP);
        l = this.subCrypt(l);
        l = Crypto.pickBits(l, FP);
        Crypto.writeBytes(l, byArray2, n2, 8);
    }

    protected long subDecrypt(long l) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        int n3 = 15;
        while (n3 >= 0) {
            int n4 = n;
            n = n2;
            n2 = n4 ^ DESKey.f(n2, this.subKeys[n3]);
            --n3;
        }
        return (long)n2 << 32 | (long)n & 0xFFFFFFFFL;
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        long l = Crypto.makeLong(byArray, n, 8);
        l = Crypto.pickBits(l, IP);
        l = this.subDecrypt(l);
        l = Crypto.pickBits(l, FP);
        Crypto.writeBytes(l, byArray2, n2, 8);
    }

    public DESKey() {
        this.key = random.nextLong();
        this.buildSubKeys();
    }

    public DESKey(byte[] byArray) {
        this.key = Crypto.makeLong(byArray, 0, 8);
        this.buildSubKeys();
    }

    public DESKey(long l) {
        this.key = l;
        this.buildSubKeys();
    }
}

