
package com.limegroup.gnutella.bootstrap;

import java.text.ParseException;

/**
 * The list of default GWebCache urls, used the first time LimeWire starts, or
 * if the gnutella.net file is accidentally deleted.  Entries in the list will
 * eventually be replaced by URLs discovered during urlfile=1 requests.  Order
 * does not matter.
 *
 * THIS FILE IS AUTOMATICALLY GENERATED FROM MAKE_DEFAULT.PY.
 */
public class DefaultBootstrapServers {
    /**
     * Adds all the default servers to bman. 
     */
    public static void addDefaults(BootstrapServerManager bman) {
        for (int i=0; i<urls.length; i++) {
            try {
                BootstrapServer server=new BootstrapServer(urls[i]);
                bman.addBootstrapServer(server);
            } catch (ParseException ignore) {
            }                
        }
    }

    //These should NOT be URL encoded.
    static String[] urls=new String[] {
    	"http://bootstrap.gtkg.net/",
    	"http://galvatron.dyndns.org:59009/gwcache",
    	"http://cache.kicks-ass.net:8000/",
    	"http://pokerface.ibiza.bishopston.net:3558/",
    	"http://tribaldance.ibiza.bishopston.net:3558/",
    	"http://krill.shacknet.nu:20095/gwc",
    	"http://gwc1c.olden.ch.3557.nyud.net:8090/gwc",
    	"http://t.az.is.teh.r0x0r.gtkg.de/",
    	"http://kisama.ath.cx:8080/",
    	"http://overbeer.ghostwhitecrab.de/"
    };
}

