/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import com.strangeberry.jmdns.tools.Browser;
import com.strangeberry.jmdns.tools.Responder;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class Main {
    public static void main(String[] stringArray) throws IOException {
        int n = stringArray.length;
        boolean bl = false;
        InetAddress inetAddress = null;
        if (n > 0 && "-d".equals(stringArray[0])) {
            System.arraycopy(stringArray, 1, stringArray, 0, --n);
            System.getProperties().put("jmdns.debug", "1");
            bl = true;
        }
        if (n > 1 && "-i".equals(stringArray[0])) {
            inetAddress = InetAddress.getByName(stringArray[1]);
            System.arraycopy(stringArray, 2, stringArray, 0, n -= 2);
        }
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        JmDNS jmDNS = new JmDNS(inetAddress);
        if (n == 0 || n >= 1 && "-browse".equals(stringArray[0])) {
            new Browser(jmDNS);
            int n2 = 2;
            while (n2 < n) {
                jmDNS.registerServiceType(stringArray[n2]);
                ++n2;
            }
        } else if (n == 1 && "-bt".equals(stringArray[0])) {
            jmDNS.addServiceTypeListener(new SampleListener());
        } else if (n == 3 && "-bs".equals(stringArray[0])) {
            jmDNS.addServiceListener(stringArray[1] + "." + stringArray[2], new SampleListener());
        } else if (n > 4 && "-rs".equals(stringArray[0])) {
            String string = stringArray[2] + "." + stringArray[3];
            String string2 = stringArray[1] + "." + string;
            Hashtable<String, String> hashtable = null;
            int n3 = 5;
            while (n3 < n) {
                int n4 = stringArray[n3].indexOf(61);
                if (n4 < 0) {
                    throw new RuntimeException("not key=val: " + stringArray[n3]);
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                hashtable.put(stringArray[n3].substring(0, n4), stringArray[n3].substring(n4 + 1));
                ++n3;
            }
            jmDNS.registerService(new ServiceInfo(string, string2, Integer.parseInt(stringArray[4]), 0, 0, hashtable));
        } else if (n == 2 && "-f".equals(stringArray[0])) {
            new Responder(jmDNS, stringArray[1]);
        } else if (!bl) {
            System.out.println();
            System.out.println("jmdns:");
            System.out.println("     -d                                       - output debugging info");
            System.out.println("     -i <addr>                                - specify the interface address");
            System.out.println("     -browse [<type>...]                      - GUI browser (default)");
            System.out.println("     -bt                                      - browse service types");
            System.out.println("     -bs <type> <domain>                      - browse services by type");
            System.out.println("     -rs <name> <type> <domain> <port> <txt>  - register service");
            System.out.println("     -f <file>                                - rendezvous responder");
            System.out.println();
            System.exit(1);
        }
    }

    static class SampleListener
    implements ServiceListener,
    ServiceTypeListener {
        SampleListener() {
        }

        public void addService(JmDNS jmDNS, String string, String string2) {
            System.out.println("ADD: " + jmDNS.getServiceInfo(string, string2, 3000));
        }

        public void removeService(JmDNS jmDNS, String string, String string2) {
            System.out.println("REMOVE: " + string2);
        }

        public void resolveService(JmDNS jmDNS, String string, String string2, ServiceInfo serviceInfo) {
            System.out.println("RESOLVED: " + serviceInfo);
        }

        public void addServiceType(JmDNS jmDNS, String string) {
            System.out.println("TYPE: " + string);
        }
    }
}

