/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteOrder {
    public static byte[] reverse(byte[] x) {
        int n = x.length;
        if (n > 0) {
            byte[] ret = new byte[n];
            int i = 0;
            int j = n - 1;
            while (j >= 0) {
                ret[i++] = x[j--];
            }
            return ret;
        }
        return x;
    }

    public static short leb2short(byte[] x, int offset) {
        return (short)(x[offset] & 0xFF | x[offset + 1] << 8);
    }

    public static short beb2short(byte[] x, int offset) {
        return (short)(x[offset] << 8 | x[offset + 1] & 0xFF);
    }

    public static short leb2short(InputStream is) throws IOException {
        return (short)(is.read() & 0xFF | is.read() << 8);
    }

    public static short beb2short(InputStream is) throws IOException {
        return (short)(is.read() << 8 | is.read() & 0xFF);
    }

    public static int leb2int(byte[] x, int offset) {
        return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16 | x[offset + 3] << 24;
    }

    public static int beb2int(byte[] x, int offset) {
        return x[offset] << 24 | (x[offset + 1] & 0xFF) << 16 | (x[offset + 2] & 0xFF) << 8 | x[offset + 3] & 0xFF;
    }

    public static int leb2int(InputStream is) throws IOException {
        return is.read() & 0xFF | (is.read() & 0xFF) << 8 | (is.read() & 0xFF) << 16 | is.read() << 24;
    }

    public static int beb2int(InputStream is) throws IOException {
        return is.read() << 24 | (is.read() & 0xFF) << 16 | (is.read() & 0xFF) << 8 | is.read() & 0xFF;
    }

    public static int leb2int(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n) {
            case 1: {
                return x[offset] & 0xFF;
            }
            case 2: {
                return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8;
            }
            case 3: {
                return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16;
            }
            case 4: {
                return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16 | x[offset + 3] << 24;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static int beb2int(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n) {
            case 1: {
                return x[offset] & 0xFF;
            }
            case 2: {
                return (x[offset] & 0xFF) << 8 | x[offset + 1] & 0xFF;
            }
            case 3: {
                return (x[offset] & 0xFF) << 16 | (x[offset + 1] & 0xFF) << 8 | x[offset + 2] & 0xFF;
            }
            case 4: {
                return x[offset] << 24 | (x[offset + 1] & 0xFF) << 16 | (x[offset + 2] & 0xFF) << 8 | x[offset + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static void short2leb(short x, byte[] buf, int offset) {
        buf[offset] = (byte)x;
        buf[offset + 1] = (byte)(x >> 8);
    }

    public static void short2beb(short x, byte[] buf, int offset) {
        buf[offset] = (byte)(x >> 8);
        buf[offset + 1] = (byte)x;
    }

    public static void short2leb(short x, OutputStream os) throws IOException {
        os.write((byte)x);
        os.write((byte)(x >> 8));
    }

    public static void short2beb(short x, OutputStream os) throws IOException {
        os.write((byte)(x >> 8));
        os.write((byte)x);
    }

    public static void int2leb(int x, byte[] buf, int offset) {
        buf[offset] = (byte)x;
        buf[offset + 1] = (byte)(x >> 8);
        buf[offset + 2] = (byte)(x >> 16);
        buf[offset + 3] = (byte)(x >> 24);
    }

    public static void int2beb(int x, byte[] buf, int offset) {
        buf[offset] = (byte)(x >> 24);
        buf[offset + 1] = (byte)(x >> 16);
        buf[offset + 2] = (byte)(x >> 8);
        buf[offset + 3] = (byte)x;
    }

    public static void int2beb(int x, OutputStream out, int n) throws IOException {
        switch (n) {
            case 1: {
                out.write((byte)x);
                break;
            }
            case 2: {
                out.write((byte)(x >> 8));
                out.write((byte)x);
                break;
            }
            case 3: {
                out.write((byte)(x >> 16));
                out.write((byte)(x >> 8));
                out.write((byte)x);
                break;
            }
            case 4: {
                out.write((byte)(x >> 24));
                out.write((byte)(x >> 16));
                out.write((byte)(x >> 8));
                out.write((byte)x);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid n: " + n);
            }
        }
    }

    public static void int2leb(int x, OutputStream os) throws IOException {
        os.write((byte)x);
        os.write((byte)(x >> 8));
        os.write((byte)(x >> 16));
        os.write((byte)(x >> 24));
    }

    public static void int2beb(int x, OutputStream os) throws IOException {
        os.write((byte)(x >> 24));
        os.write((byte)(x >> 16));
        os.write((byte)(x >> 8));
        os.write((byte)x);
    }

    public static byte[] int2minLeb(int x) throws IllegalArgumentException {
        if (x <= 65535) {
            if (x <= 255) {
                if (x < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)x};
            }
            return new byte[]{(byte)x, (byte)(x >> 8)};
        }
        if (x <= 0xFFFFFF) {
            return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16)};
        }
        return new byte[]{(byte)x, (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24)};
    }

    public static byte[] int2minBeb(int x) throws IllegalArgumentException {
        if (x <= 65535) {
            if (x <= 255) {
                if (x < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)x};
            }
            return new byte[]{(byte)(x >> 8), (byte)x};
        }
        if (x <= 0xFFFFFF) {
            return new byte[]{(byte)(x >> 16), (byte)(x >> 8), (byte)x};
        }
        return new byte[]{(byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)x};
    }

    public static int ubyte2int(byte x) {
        return x & 0xFF;
    }

    public static int ubytes2int(short x) {
        return x & 0xFFFF;
    }

    public static long ubytes2long(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        int m = Integer.MAX_VALUE;
        if (l < (long)Integer.MAX_VALUE) {
            m = Integer.MIN_VALUE;
            if (l > (long)Integer.MIN_VALUE) {
                return (int)l;
            }
        }
        return m;
    }
}

